/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch;

import com.bstek.urule.Utils;
import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.inspector.BatchListener;
import com.bstek.urule.console.batch.inspector.DefaultBatchListener;
import com.bstek.urule.console.batch.processor.ProcessorException;
import com.bstek.urule.console.batch.reader.ReaderException;
import com.bstek.urule.console.batch.service.BasicBatchService;
import com.bstek.urule.console.batch.service.BatchService;
import com.bstek.urule.console.batch.service.BatchTranService;
import com.bstek.urule.console.batch.service.HiveBatchTranService;
import com.bstek.urule.console.batch.service.HiveTranService;
import com.bstek.urule.console.batch.service.PageTranService;
import com.bstek.urule.console.batch.service.RecordTranService;
import com.bstek.urule.console.batch.service.SqlBatchException;
import com.bstek.urule.console.batch.utils.StmtUtils;
import com.bstek.urule.console.batch.writer.WriterException;
import com.bstek.urule.console.database.manager.batch.BatchManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverManager;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.log.batch.BatchLogManager;
import com.bstek.urule.console.database.manager.log.batch.BatchSkipLogManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchLog;
import com.bstek.urule.console.database.model.batch.BatchSkipLog;
import com.bstek.urule.console.database.model.batch.TranScope;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchRunHelper {
    static final Log a = LogFactory.getLog(StmtUtils.class);
    private static BatchService b = new BatchTranService();
    private static BatchService c = new PageTranService();
    private static BatchService d = new RecordTranService();
    private static BatchService e = new HiveTranService();
    private static BatchService f = new HiveBatchTranService();
    private static BatchService g = new BasicBatchService();

    protected static BatchService a(Long l) {
        List<BatchDataResolver> list = ResolverManager.ins.createQuery().batchId(l).list();
        if (list.size() > 0) {
            BatchDataResolver batchDataResolver = ResolverManager.ins.createQuery().batchId(l).list().get(0);
            return BatchRunHelper.a(batchDataResolver);
        }
        BatchDataResolver batchDataResolver = new BatchDataResolver();
        batchDataResolver.setTranScope(TranScope.page);
        return BatchRunHelper.a(batchDataResolver);
    }

    private static BatchService a(BatchDataResolver batchDataResolver) {
        BatchService batchService = null;
        batchService = TranScope.batch == batchDataResolver.getTranScope() ? b : (TranScope.page == batchDataResolver.getTranScope() ? c : (TranScope.record == batchDataResolver.getTranScope() ? d : (TranScope.hive == batchDataResolver.getTranScope() ? f : c)));
        return batchService;
    }

    protected static BatchService a(Batch batch) {
        BatchDataResolver batchDataResolver = batch.getDataResolver();
        if (batch.isThreadMulti()) {
            return BatchRunHelper.a(batchDataResolver);
        }
        if (TranScope.hive == batchDataResolver.getTranScope()) {
            return e;
        }
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void a(BatchContext batchContext) {
        BatchListener batchListener = BatchRunHelper.b(batchContext.getBatch());
        BatchResult batchResult = batchContext.getResult();
        Batch batch = batchContext.getBatch();
        try {
            BatchRunHelper.c(batchContext);
            batch.setStatus(BatchStatus.started);
            Connection connection = JdbcUtils.getConnection();
            try {
                connection.setAutoCommit(false);
                BatchLogManager.ins.add(batchContext.getBatchLog());
                BatchManager.ins.updateStatus(batch.getId(), BatchStatus.started);
                connection.commit();
            }
            catch (Exception exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
                JdbcUtils.closeConnection(connection);
            }
            batchListener.beforeExecute(batchContext);
            BatchService batchService = BatchRunHelper.a(batchContext.getBatch());
            batchService.execute(batchContext);
            batchListener.onExecute(batchContext);
            if (batchResult.getStatus() != BatchStatus.stop) {
                if (batch.getSkipLimit() > 0) {
                    if (batch.getSkipLimit() < batchResult.getExceptions().size()) {
                        throw new Exception("\u5f02\u5e38\u6570\u91cf\u8d85\u8fc7\u9ed8\u8ba4\u7ea6\u5b9a\u6570\u91cf");
                    }
                    batchResult.setStatus(BatchStatus.completed);
                    batchResult.setMsg("OK");
                    batch.setStatus(BatchStatus.completed);
                } else if (batchResult.getStatus() == BatchStatus.failed) {
                    batch.setStatus(BatchStatus.failed);
                } else {
                    batchResult.setStatus(BatchStatus.completed);
                    batchResult.setMsg("OK");
                }
            } else {
                batch.setStatus(BatchStatus.stop);
            }
            if (batch.getStatus() == BatchStatus.started) {
                batch.setStatus(BatchStatus.completed);
            }
        }
        catch (Exception exception) {
            batchResult.setStatus(BatchStatus.failed);
            batch.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
        }
        finally {
            batchResult.setEndTime(new Date());
            if (BatchStatus.started.name().equalsIgnoreCase(batchResult.getMsg())) {
                batchResult.setMsg("OK");
            }
            a.debug((Object)("execute batch \u3010" + batchContext.getBatch().getName() + "\u3011completed. BatchStatus:" + (Object)((Object)batchResult.getStatus())));
            try {
                BatchRunHelper.b(batchContext);
                batchListener.onExecute(batchContext);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void b(BatchContext batchContext) {
        BatchResult batchResult = batchContext.getResult();
        BatchLog batchLog = batchContext.getBatchLog();
        try {
            if (batchResult.getEndTime() != null) {
                batchLog.setEndTime(batchResult.getEndTime());
                batchLog.setTime(batchResult.getEndTime().getTime() - batchResult.getStartTime().getTime());
            }
            batchLog.setReadCount(batchResult.getReadCount());
            batchLog.setFilterCount(batchResult.getFilterCount());
            batchLog.setMsg(batchResult.getMsg());
            batchLog.setStatus(batchResult.getStatus());
            ObjectMapper objectMapper = new ObjectMapper();
            String string = null;
            try {
                string = objectMapper.writeValueAsString(batchResult.getItemResults());
            }
            catch (Exception exception) {
                a.error((Object)exception.getMessage());
                exception.printStackTrace();
            }
            batchLog.setItemData(string);
            if (batchResult.getExceptions().size() > 0) {
                for (Exception exception : batchResult.getExceptions()) {
                    BatchSkipLog batchSkipLog = new BatchSkipLog();
                    batchSkipLog.setBatchId(batchContext.getBatch().getId());
                    batchSkipLog.setMsg(exception.getMessage());
                    batchSkipLog.setDetail(objectMapper.writeValueAsString((Object)exception.getCause()));
                    try {
                        if (exception instanceof ReaderException) {
                            batchSkipLog.setType("reader");
                        } else if (exception instanceof ProcessorException) {
                            ProcessorException processorException = (ProcessorException)((Object)exception);
                            batchSkipLog.setType("processor");
                            batchSkipLog.setData(objectMapper.writeValueAsString(processorException.getData()));
                        } else if (exception instanceof WriterException || exception instanceof SqlBatchException) {
                            batchSkipLog.setType("writer");
                        } else {
                            batchSkipLog.setType("base");
                        }
                        batchSkipLog.setGroupId(batchLog.getGroupId());
                        batchSkipLog.setProjectId(batchLog.getProjectId());
                        batchSkipLog.setLogId(batchLog.getId());
                        BatchSkipLogManager.ins.add(batchSkipLog);
                    }
                    catch (Exception exception2) {
                        exception.printStackTrace();
                    }
                }
            }
            BatchManager.ins.updateStatus(batchLog.getBatchId(), batchContext.getBatch().getStatus());
            BatchLogManager.ins.updateStatus(batchLog);
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static void c(BatchContext batchContext) {
        BatchLog batchLog = batchContext.getBatchLog();
        try {
            BatchResult batchResult = batchContext.getResult();
            batchLog.setBatchId(batchResult.getBatchId());
            batchLog.setBatchName(batchResult.getBatchName());
            batchLog.setStartTime(batchResult.getStartTime());
            if (batchResult.getEndTime() != null) {
                batchLog.setEndTime(batchResult.getEndTime());
                batchLog.setTime(batchResult.getEndTime().getTime() - batchResult.getStartTime().getTime());
            }
            Batch batch = batchContext.getBatch();
            batchLog.setProjectId(batch.getProjectId());
            Project project = ProjectManager.ins.get(batch.getProjectId());
            Group group = GroupManager.ins.get(project.getGroupId());
            batchLog.setGroupId(group.getId());
            batchLog.setGroupName(group.getName());
            batchLog.setProjectId(batch.getProjectId());
            batchLog.setProjectName(project.getName());
            batchLog.setMsg(batchResult.getMsg());
            batchLog.setStatus(batchResult.getStatus());
            ObjectMapper objectMapper = new ObjectMapper();
            String string = null;
            try {
                string = objectMapper.writeValueAsString(batchContext.getParams());
            }
            catch (Exception exception) {
                a.error((Object)exception.getMessage());
                exception.printStackTrace();
            }
            batchLog.setInParams(string);
            batchLog.setPacketId(batch.getPacketId());
            String string2 = null;
            try {
                string2 = objectMapper.writeValueAsString(batch.getComplexPacketParams());
            }
            catch (Exception exception) {
                a.error((Object)exception.getMessage());
                exception.printStackTrace();
            }
            batchLog.setPacketParams(string2);
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static BatchListener b(Batch batch) {
        BatchListener batchListener = new DefaultBatchListener();
        try {
            if (StringUtils.isNotBlank(batch.getListener())) {
                batchListener = (BatchListener)Utils.getApplicationContext().getBean(batch.getListener());
            }
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage());
            exception.printStackTrace();
        }
        return batchListener;
    }
}

