/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch;

import com.bstek.urule.Utils;
import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchRunHelper;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.BatchThread;
import com.bstek.urule.console.batch.SchemeService;
import com.bstek.urule.console.batch.utils.StmtUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketConfig;
import com.bstek.urule.console.cache.packet.PacketData;
import com.bstek.urule.console.config.dialect.Dialect;
import com.bstek.urule.console.config.dialect.DialectResolver;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataProvider;
import com.bstek.urule.console.database.model.batch.BatchDataProviderField;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItemField;
import com.bstek.urule.console.database.model.batch.BatchLog;
import com.bstek.urule.console.database.model.batch.BatchUpdateMode;
import com.bstek.urule.console.database.model.batch.DataParam;
import com.bstek.urule.console.database.model.batch.TranScope;
import com.bstek.urule.console.database.service.repository.DataSourceHandlerManager;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.database.util.NamedSQLUtils;
import com.bstek.urule.console.database.util.ParsedSql;
import com.bstek.urule.console.editor.execute.JsonBuilder;
import com.bstek.urule.console.editor.execute.SubObject;
import com.bstek.urule.console.editor.execute.VariableCategoryNotFoundException;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.service.KnowledgeService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchServiceManager {
    public static final Log logger = LogFactory.getLog(BatchServiceManager.class);
    private static final String a = ".";
    private static final String b = "\\.";
    private static final String c = "parameter";

    private static void a(BatchResult batchResult, String string) {
        batchResult.setStatus(BatchStatus.failed);
        batchResult.setMsg(string);
    }

    private static boolean a(BatchResult batchResult, Batch batch) throws ServletException, IOException {
        Long l = batch.getPacketId();
        PacketData packetData = null;
        try {
            packetData = PacketCache.ins.getPacket(l);
        }
        catch (Throwable throwable) {
            BatchServiceManager.a(batchResult, "\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u63d0\u53d6\u5931\u8d25:" + throwable.getMessage());
            return false;
        }
        if (packetData == null) {
            BatchServiceManager.a(batchResult, "\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u4e0d\u5b58\u5728\u6216\u672a\u53d1\u5e03");
            return false;
        }
        PacketConfig packetConfig = packetData.getPacket();
        if (!packetConfig.isEnable()) {
            BatchServiceManager.a(batchResult, "\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u5df2\u505c\u7528");
            return false;
        }
        return true;
    }

    private static boolean b(BatchResult batchResult, Batch batch) throws ServletException, IOException {
        Long l = batch.getId();
        if (!batch.isEnable()) {
            BatchServiceManager.a(batchResult, "\u6279\u5904\u7406\u3010" + l + "\u3011\u5df2\u505c\u7528");
            return false;
        }
        return true;
    }

    public static void execute(Long l, Map<String, Object> map) throws Exception {
        BatchServiceManager.execute(l, map, null);
    }

    public static void execute(Long l, Map<String, Object> map, String string) throws Exception {
        BatchResult batchResult = new BatchResult();
        Batch batch = null;
        try {
            logger.debug((Object)("\u63d0\u53d6\u6279\u5904\u7406\u5bf9\u8c61\u3010" + l + "\u3011"));
            batch = SchemeService.ins.getBatchData(l);
        }
        catch (Exception exception) {
            BatchServiceManager.a(batchResult, "\u6279\u5904\u7406\u5bf9\u8c61\u3010" + l + "\u3011\u63d0\u53d6\u5931\u8d25,\u53ef\u80fd\u662f\u4e0d\u5b58\u5728\u6216\u914d\u7f6e\u5f02\u5e38");
            return;
        }
        BatchServiceManager.execute(batch, map, string, batchResult);
    }

    public static void execute(Batch batch, Map<String, Object> map, String string, BatchResult batchResult) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        batchResult.setStatus(BatchStatus.started);
        batchResult.setMsg(BatchStatus.started.name());
        batchResult.setBatchId(batch.getId());
        batchResult.setBatchName(batch.getName());
        batchResult.setStartTime(new Date());
        if (StringUtils.isBlank(batchResult.getIp())) {
            batchResult.setIp("0:0:0:0:0:0:0:1");
            batchResult.setUserAgent("Java API");
        }
        logger.debug((Object)"Validation of URule Batch ...");
        boolean bl = BatchServiceManager.b(batchResult, batch);
        if (!bl) {
            return;
        }
        logger.debug((Object)"Validation of KnowledgePackage ...");
        bl = BatchServiceManager.a(batchResult, batch);
        if (!bl) {
            return;
        }
        if (StringUtils.isNotBlank(string)) {
            batch.setListener(string);
        }
        batchResult.setStatus(BatchStatus.started);
        batchResult.setMsg(BatchStatus.started.name());
        batchResult.setBatchId(batch.getId());
        batchResult.setBatchName(batch.getName());
        batchResult.setStartTime(new Date());
        BatchLog batchLog = new BatchLog();
        batchLog.setIp(batchResult.getIp());
        batchLog.setUserAgent(batchResult.getUserAgent());
        KnowledgeService knowledgeService = (KnowledgeService)Utils.getApplicationContext().getBean("urule.knowledgeService");
        KnowledgePackage knowledgePackage = knowledgeService.getKnowledge(batch.getPacketId().toString());
        VariableCategory variableCategory = null;
        try {
            variableCategory = JsonBuilder.getInstance().findVariableCategory(knowledgePackage.getVariableCategories(), "\u53c2\u6570");
        }
        catch (VariableCategoryNotFoundException variableCategoryNotFoundException) {
            // empty catch block
        }
        VariableCategory variableCategory2 = JsonBuilder.getInstance().findVariableCategory(knowledgePackage.getVariableCategories(), batch.getDataProvider().getPacketVarName());
        logger.debug((Object)"Initialize batch parameters ...");
        for (DataParam object72 : batch.getParams()) {
            if (!map.containsKey(object72.getName())) continue;
            object72.setValue(map.get(object72.getName()));
        }
        logger.debug((Object)"Initialize packet parameters ...");
        for (DataParam dataParam : batch.getPacketParams()) {
            if (!map.containsKey(dataParam.getName())) continue;
            dataParam.setValue(map.get(dataParam.getName()));
        }
        logger.debug((Object)"Initialize dataProvider parameters ...");
        BatchDataProvider batchDataProvider = batch.getDataProvider();
        for (DataParam dataParam : batchDataProvider.getParams()) {
            if (!map.containsKey(dataParam.getBatchParamName())) continue;
            dataParam.setValue(map.get(dataParam.getBatchParamName()));
        }
        logger.debug((Object)"Initialize dataProvider dialect ...");
        DataSource dataSource = DataSourceHandlerManager.getDataSource(batch.getDataProvider().getDatasource());
        Object var12_18 = null;
        try {
            Connection connection = dataSource.getConnection();
            object4 = DialectResolver.resolveDialect(connection);
            batch.getDataProvider().setDialect((Dialect)object4);
            connection.close();
        }
        catch (Exception exception) {
            logger.error((Object)("close connection error:" + exception.getMessage()));
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
            return;
        }
        object4 = batch.getDataResolver();
        logger.debug((Object)"Initialize dataResolver dialect ...");
        DataSource dataSource2 = DataSourceHandlerManager.getDataSource(((BatchDataResolver)object4).getDatasource());
        Connection connection = null;
        try {
            connection = dataSource2.getConnection();
            object3 = DialectResolver.resolveDialect(connection);
            ((BatchDataResolver)object4).setDialect((Dialect)object3);
            connection.close();
        }
        catch (Exception exception) {
            logger.error((Object)("close connection error:" + exception.getMessage()));
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
            return;
        }
        object3 = ((BatchDataResolver)object4).getItems();
        Object object5 = object3.iterator();
        while (object5.hasNext()) {
            object2 = (BatchDataResolverItem)object5.next();
            BatchUpdateMode batchUpdateMode = ((BatchDataResolverItem)object2).getUpdateMode();
            if (BatchUpdateMode.insert != batchUpdateMode || ((BatchDataResolver)object4).getTranScope() != TranScope.hive) continue;
            object = new ArrayList<DataParam>();
            String string2 = BatchServiceManager.a(batch.getParams(), object, (BatchDataResolverItem)object2);
            ((BatchDataResolverItem)object2).setUpdateSql(string2);
            ((BatchDataResolverItem)object2).setParams((List<DataParam>)object);
        }
        logger.debug((Object)"Initialize BatchContext ...");
        object5 = new BatchContext(batch, map, batchResult);
        ((BatchContext)object5).setBatchLog(batchLog);
        ((BatchContext)object5).setKnowledgePackage(knowledgePackage);
        ((BatchContext)object5).setKnowledgeService(knowledgeService);
        ((BatchContext)object5).setParameterVariableCategory(variableCategory);
        ((BatchContext)object5).setProviderVariableCategory(variableCategory2);
        logger.debug((Object)"Initialize packet provider parameters ...");
        for (DataParam dataParam : batch.getPacketParams()) {
            if (!dataParam.getDataType().equals("Object") && !dataParam.getDataType().equals("List") || dataParam.getDataProviderId() == null || dataParam.getDataProviderId() <= 0L) continue;
            BatchServiceManager.a(map, dataParam, (BatchContext)object5);
        }
        logger.debug((Object)"Initialize packet complex parameters ...");
        object2 = BatchServiceManager.a(batch.getPacketParams(), knowledgePackage);
        batch.setComplexPacketParams((Map<String, Object>)object2);
        logger.debug((Object)"Initialize packet out parameters ...");
        List<String> list = BatchServiceManager.generateOutParamNames((BatchContext)object5);
        batch.setOutParameterNameList(list);
        if (batch.isAsync()) {
            object = new BatchThread((BatchContext)object5);
            ((Thread)object).start();
        } else {
            BatchRunHelper.a((BatchContext)object5);
        }
    }

    protected static String a(List<DataParam> list, List<DataParam> list2, BatchDataResolverItem batchDataResolverItem) {
        String string = batchDataResolverItem.getTableName();
        List<BatchDataResolverItemField> list3 = batchDataResolverItem.getFields();
        String string2 = "insert into " + string + " ";
        String string3 = batchDataResolverItem.getPartitionName();
        String string4 = batchDataResolverItem.getPartitionValue();
        if (StringUtils.isNotBlank(string3)) {
            if (StringUtils.isNotBlank(string4)) {
                boolean bl = false;
                for (DataParam object : list) {
                    if (!string4.equals(object.getName())) continue;
                    bl = true;
                    string2 = string2 + "partition (" + string3 + "='" + object.getValue() + "') ";
                }
                if (!bl) {
                    string2 = string2 + "partition (" + string3 + "='" + string4 + "') ";
                }
            } else {
                string2 = string2 + "partition (" + string3 + ") ";
            }
        }
        String string5 = "";
        for (BatchDataResolverItemField batchDataResolverItemField : list3) {
            if (StringUtils.isNotEmpty(string5)) {
                string5 = string5 + ", ";
            }
            string5 = string5 + batchDataResolverItemField.getDestProperty();
            DataParam dataParam = new DataParam();
            dataParam.setDataType(batchDataResolverItemField.getDataType());
            dataParam.setName(batchDataResolverItemField.getSrcProperty());
            dataParam.setIndex(list2.size());
            list2.add(dataParam);
        }
        string2 = string2 + "(" + string5 + ") ";
        return string2;
    }

    public static List<String> generateOutParamNames(BatchContext batchContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BatchDataResolver batchDataResolver = batchContext.getBatch().getDataResolver();
        List<BatchDataResolverItem> list = batchDataResolver.getItems();
        for (BatchDataResolverItem batchDataResolverItem : list) {
            for (BatchDataResolverItemField batchDataResolverItemField : batchDataResolverItem.getFields()) {
                String string;
                List<String> list2;
                boolean bl;
                String string2 = batchDataResolverItemField.getSrcProperty();
                if (string2.indexOf(a) == -1 || !(bl = c.equals((list2 = Arrays.asList(string2.split(b))).get(0))) || arrayList.contains(string = list2.get(1))) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static Map<String, Object> a(List<DataParam> list, KnowledgePackage knowledgePackage) throws Exception {
        DataParam dataParam2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (DataParam dataParam2 : list) {
            if (dataParam2.getValue() == null) continue;
            hashMap.put(dataParam2.getName(), dataParam2.getValue());
        }
        HashMap<String, Object> hashMap2 = hashMap;
        dataParam2 = null;
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        try {
            List list2 = knowledgePackage.getVariableCategories();
            Map<String, VariableCategory> map = JsonBuilder.getInstance().buildVariableCategoriesMap(list2);
            dataParam2 = map.get("\u53c2\u6570");
            if (dataParam2 == null) {
                throw new VariableCategoryNotFoundException("\u53d8\u91cf\u5bf9\u8c61\u3010\u53c2\u6570\u3011\u672a\u5b9a\u4e49!");
            }
            for (String string : hashMap2.keySet()) {
                Object v = hashMap2.get(string);
                if (v == null) continue;
                Variable variable = JsonBuilder.getInstance().findVariable((VariableCategory)dataParam2, string);
                Datatype datatype = variable.getType();
                SubObject subObject = JsonBuilder.getInstance().findSubObject(variable.getName(), hashMap3);
                Map<String, Object> map2 = subObject.getMap();
                if (datatype.equals((Object)Datatype.Object) || datatype.equals((Object)Datatype.List)) {
                    map2.put(subObject.getName(), JsonBuilder.getInstance().buildComplexObject(v, map));
                    continue;
                }
                map2.put(subObject.getName(), datatype.convert(v));
            }
        }
        catch (VariableCategoryNotFoundException variableCategoryNotFoundException) {
            // empty catch block
        }
        return hashMap3;
    }

    private static void a(Map<String, Object> map, DataParam dataParam, BatchContext batchContext) {
        block11: {
            Long l = dataParam.getDataProviderId();
            BatchDataProvider batchDataProvider = SchemeService.ins.getProviderData(l);
            if (batchDataProvider != null && batchDataProvider.getDatasource() != null) {
                Connection connection = null;
                try {
                    DataSource dataSource = batchContext.getReaderDataSoruceMap().get(batchDataProvider.getDatasourceId());
                    if (dataSource == null) {
                        dataSource = DataSourceHandlerManager.getDataSource(batchDataProvider.getDatasource());
                        batchContext.getReaderDataSoruceMap().put(batchDataProvider.getDatasourceId(), dataSource);
                    }
                    connection = dataSource.getConnection();
                    BatchServiceManager.a(batchDataProvider, batchContext.getParamValueMap());
                    BatchServiceManager.a(batchDataProvider, map);
                    List<GeneralEntity> list = BatchServiceManager.a(connection, batchDataProvider, batchContext.getKnowledgePackage().getVariableCategories());
                    if (list.size() > 0) {
                        if (dataParam.getDataType().equals("List")) {
                            map.put(dataParam.getName(), list);
                        } else if (dataParam.getDataType().equals("Object")) {
                            map.put(dataParam.getName(), list.get(0));
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                    if (connection == null) break block11;
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        logger.debug((Object)"Could not close JDBC Connection", (Throwable)sQLException);
                    }
                    catch (Throwable throwable) {
                        logger.debug((Object)"Unexpected exception on closing JDBC Connection", throwable);
                    }
                }
            }
        }
    }

    private static List<GeneralEntity> a(Connection connection, BatchDataProvider batchDataProvider, List<VariableCategory> list) throws Exception {
        VariableCategory variableCategory = JsonBuilder.getInstance().findVariableCategory(list, batchDataProvider.getPacketVarName());
        Connection connection2 = null;
        ArrayList<GeneralEntity> arrayList = new ArrayList<GeneralEntity>();
        try {
            connection2 = connection;
            ParsedSql parsedSql = NamedSQLUtils.parseSql(batchDataProvider.getPageSql());
            String string = JdbcUtils.getOriginSql(parsedSql.getOriginalSql());
            PreparedStatement preparedStatement = connection2.prepareStatement(string);
            StmtUtils.setStmtQueryParameters(parsedSql, batchDataProvider.getParams(), preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<BatchDataProviderField> list2 = batchDataProvider.getFields();
            while (resultSet.next()) {
                GeneralEntity generalEntity = null;
                generalEntity = batchDataProvider.getPacketVarName().equals("\u53c2\u6570") ? new GeneralEntity() : new GeneralEntity(variableCategory.getClazz());
                for (BatchDataProviderField batchDataProviderField : list2) {
                    if ("Boolean".equals(batchDataProviderField.getDataType())) {
                        generalEntity.put((Object)batchDataProviderField.getDestProperty(), (Object)resultSet.getBoolean(batchDataProviderField.getSrcProperty()));
                        continue;
                    }
                    generalEntity.put((Object)batchDataProviderField.getDestProperty(), resultSet.getObject(batchDataProviderField.getSrcProperty()));
                }
                arrayList.add(generalEntity);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return arrayList;
    }

    private static void a(BatchDataProvider batchDataProvider, Map<String, Object> map) {
        for (DataParam dataParam : batchDataProvider.getParams()) {
            if (!map.containsKey(dataParam.getBatchParamName())) continue;
            dataParam.setValue(map.get(dataParam.getBatchParamName()));
        }
    }
}

