/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch;

import com.bstek.urule.Utils;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.SchemeService;
import com.bstek.urule.console.batch.filter.PropertyFilter;
import com.bstek.urule.console.batch.utils.JsonUtils;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.batch.BatchManager;
import com.bstek.urule.console.database.manager.batch.BatchManagerHelper;
import com.bstek.urule.console.database.manager.batch.provider.ProviderFieldManager;
import com.bstek.urule.console.database.manager.batch.provider.ProviderFieldQuery;
import com.bstek.urule.console.database.manager.batch.provider.ProviderManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverFieldManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverFieldQuery;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverItemManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverManager;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.repository.DataSourceManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataProvider;
import com.bstek.urule.console.database.model.batch.BatchDataProviderField;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItemField;
import com.bstek.urule.console.database.model.batch.BatchUpdateMode;
import com.bstek.urule.console.database.model.batch.DataParam;
import com.bstek.urule.console.database.model.batch.Filter;
import com.bstek.urule.console.database.model.batch.FilterItem;
import com.bstek.urule.console.database.model.batch.FilterType;
import com.bstek.urule.console.database.model.datasource.DataSource;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemeServiceImpl
implements SchemeService {
    private static Log a = LogFactory.getLog(SchemeServiceImpl.class);

    @Override
    public void add(Batch batch, String string) {
        batch.setId(IDGenerator.getInstance().nextId(IDType.BATCH));
        batch.setStatus(BatchStatus.none);
        batch.setProjectId(ContextHolder.getProjectId());
        batch.setCreateUser(string);
        batch.setCreateDate(new Date());
        BatchManager.ins.add(batch);
        if (batch.getPacketParams() != null) {
            for (DataParam dataParam : batch.getPacketParams()) {
                if (!dataParam.getDataType().equals("Object") && !dataParam.getDataType().equals("List") || !StringUtils.isBlank(dataParam.getBatchParamName())) continue;
                this.a(batch, dataParam, string);
            }
        }
        if (batch.getDataProvider() != null) {
            this.a(batch, string);
        }
        if (batch.getDataResolver() != null) {
            this.b(batch, string);
        }
        if (batch.getDataProvider() != null || batch.getDataResolver() != null) {
            batch.setUpdateUser(string);
            batch.setUpdateDate(new Date());
            BatchManager.ins.update(batch);
        }
    }

    @Override
    public void update(Batch batch, String string) {
        Object object;
        batch.setUpdateUser(string);
        batch.setUpdateDate(new Date());
        BatchManager.ins.update(batch);
        if (batch.getPacketParams() != null) {
            for (DataParam object2 : batch.getPacketParams()) {
                if (!object2.getDataType().equals("Object") && !object2.getDataType().equals("List") || !StringUtils.isBlank(object2.getBatchParamName())) continue;
                this.a(batch, string, object2, object2.getDataProvider());
            }
        }
        if (batch.getDataProvider() != null) {
            object = batch.getDataProvider();
            this.a(batch, string, (BatchDataProvider)object);
        }
        if (batch.getDataResolver() != null) {
            object = batch.getDataResolver();
            if (((BatchDataResolver)object).getId() == null || ((BatchDataResolver)object).getId() == 0L) {
                this.b(batch, string);
            } else {
                ((BatchDataResolver)object).setUpdateUser(string);
                ((BatchDataResolver)object).setUpdateDate(new Date());
                ResolverManager.ins.update((BatchDataResolver)object);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                List<BatchDataResolverItem> list = ResolverItemManager.ins.createQuery().resolverId(((BatchDataResolver)object).getId()).list();
                for (BatchDataResolverItem batchDataResolverItem : ((BatchDataResolver)object).getItems()) {
                    if (batchDataResolverItem.getId() == null || batchDataResolverItem.getId() == 0L) {
                        this.a(string, (BatchDataResolver)object, batchDataResolverItem);
                    } else {
                        batchDataResolverItem.setUpdateUser(string);
                        batchDataResolverItem.setUpdateDate(new Date());
                        ResolverItemManager.ins.update(batchDataResolverItem);
                        List<BatchDataResolverItemField> list2 = ResolverFieldManager.ins.createQuery().itemId(batchDataResolverItem.getId()).list();
                        ArrayList<Long> arrayList2 = new ArrayList<Long>();
                        for (BatchDataResolverItemField batchDataResolverItemField : batchDataResolverItem.getFields()) {
                            if (batchDataResolverItemField.getId() == 0L || batchDataResolverItemField.getId() == null) {
                                this.a(string, batchDataResolverItem, batchDataResolverItemField);
                            } else {
                                batchDataResolverItemField.setUpdateUser(string);
                                batchDataResolverItemField.setUpdateDate(new Date());
                                ResolverFieldManager.ins.update(batchDataResolverItemField);
                            }
                            arrayList2.add(batchDataResolverItemField.getId());
                        }
                        for (BatchDataResolverItemField batchDataResolverItemField : list2) {
                            if (arrayList2.contains(batchDataResolverItemField.getId())) continue;
                            ResolverFieldManager.ins.remove(batchDataResolverItemField.getId());
                        }
                    }
                    arrayList.add(batchDataResolverItem.getId());
                }
                for (BatchDataResolverItem batchDataResolverItem : list) {
                    if (arrayList.contains(batchDataResolverItem.getId())) continue;
                    BatchManagerHelper.removeResolverItem(batchDataResolverItem.getId());
                }
            }
        }
        BatchManager.ins.update(batch);
    }

    private void a(Batch batch, String string, DataParam dataParam, BatchDataProvider batchDataProvider) {
        if (batchDataProvider.getId() == null || batchDataProvider.getId() == 0L) {
            this.a(batch, dataParam, string);
        } else {
            batchDataProvider.setSupportsPaging(false);
            batchDataProvider.setUpdateUser(string);
            batchDataProvider.setUpdateDate(new Date());
            ProviderManager.ins.update(batchDataProvider);
            List<BatchDataProviderField> list = ProviderFieldManager.ins.createQuery().providerId(batchDataProvider.getId()).list();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (BatchDataProviderField batchDataProviderField : batchDataProvider.getFields()) {
                if (batchDataProviderField.getId() == null || batchDataProviderField.getId() == 0L) {
                    this.a(batch, string, batchDataProvider, batchDataProviderField);
                } else {
                    batchDataProviderField.setUpdateUser(string);
                    batchDataProviderField.setUpdateDate(new Date());
                    if (this.a(batchDataProviderField)) {
                        if (batchDataProviderField.getDataProviderId() == null || batchDataProviderField.getDataProviderId() == 0L || batchDataProviderField.getDataProvider() == null) {
                            this.a(batch, string, batchDataProviderField);
                        } else {
                            this.a(batch, string, batchDataProviderField, batchDataProviderField.getDataProvider());
                        }
                    }
                    ProviderFieldManager.ins.update(batchDataProviderField);
                }
                arrayList.add(batchDataProviderField.getId());
            }
            for (BatchDataProviderField batchDataProviderField : list) {
                if (arrayList.contains(batchDataProviderField.getId())) continue;
                if (batchDataProviderField.getDataProviderId() != null) {
                    this.removeProvider(batchDataProviderField.getDataProviderId(), batch.getId());
                }
                ProviderFieldManager.ins.remove(batchDataProviderField.getId());
            }
        }
    }

    private void a(Batch batch, String string, BatchDataProvider batchDataProvider) {
        if (batchDataProvider.getId() == null || batchDataProvider.getId() == 0L) {
            this.a(batch, string);
        } else {
            batchDataProvider.setUpdateUser(string);
            batchDataProvider.setUpdateDate(new Date());
            ProviderManager.ins.update(batchDataProvider);
            List<BatchDataProviderField> list = ProviderFieldManager.ins.createQuery().providerId(batchDataProvider.getId()).list();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (BatchDataProviderField batchDataProviderField : batchDataProvider.getFields()) {
                if (batchDataProviderField.getId() == null || batchDataProviderField.getId() == 0L) {
                    this.a(batch, string, batchDataProvider, batchDataProviderField);
                } else {
                    batchDataProviderField.setUpdateUser(string);
                    batchDataProviderField.setUpdateDate(new Date());
                    if (this.a(batchDataProviderField)) {
                        if (batchDataProviderField.getDataProviderId() == null || batchDataProviderField.getDataProviderId() == 0L || batchDataProviderField.getDataProvider() == null) {
                            this.a(batch, string, batchDataProviderField);
                        } else {
                            this.a(batch, string, batchDataProviderField, batchDataProviderField.getDataProvider());
                        }
                    }
                    ProviderFieldManager.ins.update(batchDataProviderField);
                }
                arrayList.add(batchDataProviderField.getId());
            }
            for (BatchDataProviderField batchDataProviderField : list) {
                if (arrayList.contains(batchDataProviderField.getId())) continue;
                if (batchDataProviderField.getDataProviderId() != null) {
                    this.removeProvider(batchDataProviderField.getDataProviderId(), batch.getId());
                }
                ProviderFieldManager.ins.remove(batchDataProviderField.getId());
            }
        }
    }

    private void a(Batch batch, String string, BatchDataProviderField batchDataProviderField, BatchDataProvider batchDataProvider) {
        if (batchDataProvider.getId() == null || batchDataProvider.getId() == 0L) {
            this.a(batch, string, batchDataProviderField);
        } else {
            batchDataProvider.setSupportsPaging(false);
            batchDataProvider.setUpdateUser(string);
            batchDataProvider.setUpdateDate(new Date());
            ProviderManager.ins.update(batchDataProvider);
            List<BatchDataProviderField> list = ProviderFieldManager.ins.createQuery().providerId(batchDataProvider.getId()).list();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (BatchDataProviderField batchDataProviderField2 : batchDataProvider.getFields()) {
                if (batchDataProviderField2.getId() == null || batchDataProviderField2.getId() == 0L) {
                    this.a(batch, string, batchDataProvider, batchDataProviderField2);
                } else {
                    batchDataProviderField2.setUpdateUser(string);
                    batchDataProviderField2.setUpdateDate(new Date());
                    ProviderFieldManager.ins.update(batchDataProviderField2);
                    if (this.a(batchDataProviderField2)) {
                        if (batchDataProviderField2.getDataProviderId() == null || batchDataProviderField2.getDataProviderId() == 0L || batchDataProviderField2.getDataProvider() == null) {
                            this.a(batch, string, batchDataProviderField2);
                        } else {
                            this.a(batch, string, batchDataProviderField2, batchDataProviderField2.getDataProvider());
                        }
                    }
                }
                arrayList.add(batchDataProviderField2.getId());
            }
            for (BatchDataProviderField batchDataProviderField2 : list) {
                if (arrayList.contains(batchDataProviderField2.getId())) continue;
                ProviderFieldManager.ins.remove(batchDataProviderField2.getId());
                if (batchDataProviderField2.getDataProviderId() == null) continue;
                this.removeProvider(batchDataProviderField2.getDataProviderId(), batch.getId());
            }
        }
    }

    public void removeProvider(long l, long l2) {
        List<BatchDataProviderField> list = ProviderFieldManager.ins.createQuery().providerId(l).batchId(l2).list();
        for (BatchDataProviderField batchDataProviderField : list) {
            if (batchDataProviderField.getDataProviderId() != null) {
                this.removeProvider(batchDataProviderField.getDataProviderId(), l2);
            }
            ProviderFieldManager.ins.remove(batchDataProviderField.getId());
        }
        ProviderManager.ins.remove(l);
    }

    @Override
    public void remove(Long l) {
        ProviderFieldManager.ins.removeByBatchId(l);
        ProviderManager.ins.removeByBatchId(l);
        ResolverFieldManager.ins.removeByBatchId(l);
        ResolverItemManager.ins.removeByBatchId(l);
        ResolverManager.ins.removeByBatchId(l);
        BatchManager.ins.remove(l);
    }

    private void a(Batch batch, String string) {
        BatchDataProvider batchDataProvider = batch.getDataProvider();
        batchDataProvider.setId(IDGenerator.getInstance().nextId(IDType.BATCH_DATA_PROVIDER));
        batchDataProvider.setBatchId(batch.getId());
        batchDataProvider.setProjectId(batch.getProjectId());
        batchDataProvider.setCreateUser(string);
        batchDataProvider.setCreateDate(new Date());
        batchDataProvider.setName("DataProvider");
        ProviderManager.ins.add(batchDataProvider);
        batch.setProviderId(batchDataProvider.getId());
        if (batchDataProvider.getFields() != null) {
            for (BatchDataProviderField batchDataProviderField : batchDataProvider.getFields()) {
                this.a(batch, string, batchDataProvider, batchDataProviderField);
            }
        }
    }

    private void a(Batch batch, DataParam dataParam, String string) {
        BatchDataProvider batchDataProvider = dataParam.getDataProvider();
        if (batchDataProvider == null) {
            batchDataProvider = new BatchDataProvider();
            batchDataProvider.setDatasourceId(0L);
            batchDataProvider.setName("Packet Parameter Data Provider");
            dataParam.setDataProvider(batchDataProvider);
        }
        batchDataProvider.setSupportsPaging(false);
        batchDataProvider.setId(IDGenerator.getInstance().nextId(IDType.BATCH_DATA_PROVIDER));
        batchDataProvider.setBatchId(batch.getId());
        batchDataProvider.setProjectId(batch.getProjectId());
        batchDataProvider.setCreateUser(string);
        batchDataProvider.setCreateDate(new Date());
        batchDataProvider.setName("DataProvider");
        ProviderManager.ins.add(batchDataProvider);
        dataParam.setDataProviderId(batchDataProvider.getId());
        if (batchDataProvider.getFields() != null) {
            for (BatchDataProviderField batchDataProviderField : batchDataProvider.getFields()) {
                this.a(batch, string, batchDataProvider, batchDataProviderField);
            }
        }
    }

    private boolean a(BatchDataProviderField batchDataProviderField) {
        return "Object".equals(batchDataProviderField.getDataType()) || "List".equals(batchDataProviderField.getDataType()) || "JsonObject".equals(batchDataProviderField.getDataType()) || "JsonArray".equals(batchDataProviderField.getDataType());
    }

    private void a(Batch batch, String string, BatchDataProvider batchDataProvider, BatchDataProviderField batchDataProviderField) {
        batchDataProviderField.setBatchId(batch.getId());
        batchDataProviderField.setProviderId(batchDataProvider.getId());
        batchDataProviderField.setProjectId(batch.getProjectId());
        batchDataProviderField.setId(IDGenerator.getInstance().nextId(IDType.BATCH_PROVIDER_FIELD));
        batchDataProviderField.setCreateUser(string);
        batchDataProviderField.setCreateDate(new Date());
        if ((batchDataProviderField.getDataProviderId() == null || batchDataProviderField.getDataProviderId() == 0L) && this.a(batchDataProviderField)) {
            this.a(batch, string, batchDataProviderField);
        }
        ProviderFieldManager.ins.add(batchDataProviderField);
    }

    private void a(Batch batch, String string, BatchDataProviderField batchDataProviderField) {
        BatchDataProvider batchDataProvider = batchDataProviderField.getDataProvider();
        if (batchDataProvider == null) {
            batchDataProvider = new BatchDataProvider();
            batchDataProvider.setDatasourceId(0L);
            batchDataProvider.setName("Field Data Provider");
            batchDataProviderField.setDataProvider(batchDataProvider);
        }
        batchDataProvider.setSupportsPaging(false);
        batchDataProvider.setId(IDGenerator.getInstance().nextId(IDType.BATCH_DATA_PROVIDER));
        batchDataProvider.setBatchId(batch.getId());
        batchDataProvider.setProjectId(batch.getProjectId());
        batchDataProvider.setCreateUser(string);
        batchDataProvider.setCreateDate(new Date());
        ProviderManager.ins.add(batchDataProviderField.getDataProvider());
        batchDataProviderField.setDataProviderId(batchDataProvider.getId());
        if (batchDataProvider.getFields() != null) {
            for (BatchDataProviderField batchDataProviderField2 : batchDataProvider.getFields()) {
                this.a(batch, string, batchDataProvider, batchDataProviderField2);
            }
        }
    }

    private void b(Batch batch, String string) {
        BatchDataResolver batchDataResolver = batch.getDataResolver();
        batchDataResolver.setId(IDGenerator.getInstance().nextId(IDType.BATCH_DATA_RESOLVER));
        batchDataResolver.setBatchId(batch.getId());
        batchDataResolver.setProjectId(batch.getProjectId());
        batchDataResolver.setCreateUser(string);
        batchDataResolver.setCreateDate(new Date());
        batchDataResolver.setName("DataResolver");
        ResolverManager.ins.add(batchDataResolver);
        batch.setResolverId(batchDataResolver.getId());
        if (batchDataResolver.getItems() != null) {
            for (BatchDataResolverItem batchDataResolverItem : batchDataResolver.getItems()) {
                this.a(string, batchDataResolver, batchDataResolverItem);
            }
        }
    }

    private void a(String string, BatchDataResolver batchDataResolver, BatchDataResolverItem batchDataResolverItem) {
        batchDataResolverItem.setId(IDGenerator.getInstance().nextId(IDType.BATCH_RESOLVER_ITEM));
        batchDataResolverItem.setResolverId(batchDataResolver.getId());
        batchDataResolverItem.setBatchId(batchDataResolver.getBatchId());
        batchDataResolverItem.setProjectId(batchDataResolver.getProjectId());
        batchDataResolverItem.setCreateUser(string);
        batchDataResolverItem.setCreateDate(new Date());
        ResolverItemManager.ins.add(batchDataResolverItem);
        if (batchDataResolverItem.getFields() != null) {
            for (BatchDataResolverItemField batchDataResolverItemField : batchDataResolverItem.getFields()) {
                this.a(string, batchDataResolverItem, batchDataResolverItemField);
            }
        }
    }

    private void a(String string, BatchDataResolverItem batchDataResolverItem, BatchDataResolverItemField batchDataResolverItemField) {
        batchDataResolverItemField.setBatchId(batchDataResolverItem.getBatchId());
        batchDataResolverItemField.setResolverItemId(batchDataResolverItem.getId());
        batchDataResolverItemField.setResolverId(batchDataResolverItem.getResolverId());
        batchDataResolverItemField.setProjectId(batchDataResolverItem.getProjectId());
        batchDataResolverItemField.setId(IDGenerator.getInstance().nextId(IDType.BATCH_RESOLVER_FIELD));
        batchDataResolverItemField.setCreateUser(string);
        batchDataResolverItemField.setCreateDate(new Date());
        ResolverFieldManager.ins.add(batchDataResolverItemField);
    }

    @Override
    public void disable(Long l, String string) {
        Batch batch = BatchManager.ins.get(l);
        if (batch != null) {
            batch.setEnable(false);
            batch.setUpdateDate(new Date());
            batch.setUpdateUser(string);
            BatchManager.ins.update(batch);
        }
    }

    @Override
    public void enable(Long l, String string) {
        Batch batch = this.getBatchData(l);
        if (batch != null) {
            if (StringUtils.isBlank(batch.getName())) {
                throw new RuleException("\u6279\u5904\u7406\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (batch.getPacketId() == null || batch.getPacketId() == 0L) {
                throw new RuleException("\u6279\u5904\u7406\u77e5\u8bc6\u5305\u5c5e\u6027\u6ca1\u6709\u8bbe\u7f6e");
            }
            if (batch.isRestEnable() && batch.isRestSecurityEnable() && (StringUtils.isBlank(batch.getRestSecurityUser()) || StringUtils.isBlank(batch.getRestSecurityPassword()))) {
                throw new RuleException("\u6279\u5904\u7406\u542f\u7528Rest\u5b89\u5168\u8bbe\u7f6e\u540e\u9700\u8981\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7528\u6237\u540d\u548c\u5bc6\u7801");
            }
            if (batch.isThreadMulti() && (batch.getThreadSize() <= 0 || batch.getThreadDataSize() <= 0)) {
                throw new RuleException("\u6279\u5904\u7406\u542f\u7528\u591a\u7ebf\u7a0b\u540e\u7ebf\u7a0b\u6570\u6216\u7ebf\u7a0b\u6570\u636e\u91cf\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0");
            }
            List<DataParam> list = batch.getPacketParams();
            for (DataParam object2 : list) {
                BatchDataProvider batchDataProvider = object2.getDataProvider();
                if (batchDataProvider == null) continue;
                this.a(batchDataProvider);
            }
            BatchDataProvider batchDataProvider = batch.getDataProvider();
            if (batchDataProvider == null) {
                throw new RuleException("\u6279\u5904\u7406\u672a\u5b9a\u4e49\u6570\u636e\u52a0\u8f7d\u5668");
            }
            this.a(batchDataProvider);
            BatchDataResolver batchDataResolver = batch.getDataResolver();
            if (batchDataResolver == null) {
                throw new RuleException("\u6279\u5904\u7406\u672a\u5b9a\u4e49\u6570\u636e\u5904\u7406\u5668");
            }
            this.a(batchDataResolver);
            batch.setEnable(true);
            batch.setUpdateDate(new Date());
            batch.setUpdateUser(string);
            BatchManager.ins.update(batch);
        }
    }

    private void a(BatchDataProvider batchDataProvider) {
        if (StringUtils.isBlank(batchDataProvider.getPacketVarName())) {
            throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u7684\u77e5\u8bc6\u5305\u53d8\u91cf\u540d\u672a\u7ed1\u5b9a");
        }
        if (StringUtils.isBlank(batchDataProvider.getPageSql())) {
            throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u7684\u5206\u9875SQL\u6ca1\u6709\u5b9a\u4e49");
        }
        if (batchDataProvider.isSupportsPaging().booleanValue() && StringUtils.isBlank(batchDataProvider.getCountSql())) {
            throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u7684\u603b\u8bb0\u5f55\u6570SQL\u6ca1\u6709\u5b9a\u4e49");
        }
        DataSource dataSource = batchDataProvider.getDatasource();
        if (dataSource == null) {
            throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u672a\u7ed1\u5b9a\u6570\u636e\u6e90");
        }
        List<BatchDataProviderField> list = batchDataProvider.getFields();
        if (list == null || list.size() == 0) {
            throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u672a\u8bbe\u7f6e\u53d8\u91cf\u6620\u5c04");
        }
        for (BatchDataProviderField batchDataProviderField : list) {
            if (StringUtils.isBlank(batchDataProviderField.getDestProperty())) {
                throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u53d8\u91cf\u6620\u5c04\u7ed1\u5b9a\u5c5e\u6027\u8bbe\u7f6e\u4e0d\u5b8c\u6574,\u672a\u8bbe\u7f6e\u53d8\u91cf\u5c5e\u6027");
            }
            if (StringUtils.isBlank(batchDataProviderField.getDataType())) {
                throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u53d8\u91cf\u6620\u5c04\u7ed1\u5b9a\u5c5e\u6027\u8bbe\u7f6e\u4e0d\u5b8c\u6574,\u672a\u8bbe\u7f6e\u53d8\u91cf\u6570\u636e\u7c7b\u578b");
            }
            if (!batchDataProviderField.getDataType().equalsIgnoreCase("Object") && !batchDataProviderField.getDataType().equalsIgnoreCase("List")) {
                if (!StringUtils.isBlank(batchDataProviderField.getDestProperty())) continue;
                throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u53d8\u91cf\u6620\u5c04\u7ed1\u5b9a\u5c5e\u6027\u8bbe\u7f6e\u4e0d\u5b8c\u6574,\u672a\u8bbe\u7f6e\u5b57\u6bb5\u5c5e\u6027");
            }
            BatchDataProvider batchDataProvider2 = batchDataProviderField.getDataProvider();
            if (batchDataProvider2 == null) {
                throw new RuleException("\u6570\u636e\u52a0\u8f7d\u5668\u5bf9\u8c61\u53d8\u91cf\u672a\u5b9a\u4e49\u6570\u636e\u52a0\u8f7d\u5668");
            }
            this.a(batchDataProvider2);
        }
    }

    private void a(BatchDataResolver batchDataResolver) {
        DataSource dataSource = batchDataResolver.getDatasource();
        if (dataSource == null) {
            throw new RuleException("\u6570\u636e\u5904\u7406\u5668\u5bf9\u8c61\u672a\u7ed1\u5b9a\u6570\u636e\u6e90");
        }
        List<BatchDataResolverItem> list = batchDataResolver.getItems();
        if (list == null || list.size() == 0) {
            throw new RuleException("\u6570\u636e\u5904\u7406\u5668\u5bf9\u8c61\u672a\u6dfb\u52a0\u6570\u636e\u66f4\u65b0\u9879");
        }
        for (BatchDataResolverItem batchDataResolverItem : list) {
            if (StringUtils.isBlank(batchDataResolverItem.getName())) {
                throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u7684\u540d\u79f0\u672a\u8bbe\u7f6e");
            }
            if (StringUtils.isBlank(batchDataResolverItem.getTableName())) {
                throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u3010" + batchDataResolverItem.getName() + "\u3011\u7684\u76ee\u6807\u7269\u7406\u8868\u672a\u8bbe\u7f6e");
            }
            List<BatchDataResolverItemField> list2 = batchDataResolverItem.getFields();
            if (list2 == null || list2.size() == 0) {
                throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u3010" + batchDataResolverItem.getName() + "\u3011\u672a\u914d\u7f6e\u6570\u636e\u6620\u5c04");
            }
            boolean bl = false;
            for (BatchDataResolverItemField batchDataResolverItemField : list2) {
                if (StringUtils.isBlank(batchDataResolverItemField.getSrcProperty())) {
                    throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u7684\u6570\u636e\u6620\u5c04\u5b9a\u4e49\u4e0d\u5b8c\u6574,\u6ca1\u6709\u5b9a\u4e49\u5bf9\u5e94\u7684\u53d8\u91cf\u5c5e\u6027\u540d");
                }
                if (StringUtils.isBlank(batchDataResolverItemField.getDataType())) {
                    throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u7684\u6570\u636e\u6620\u5c04\u5b9a\u4e49\u4e0d\u5b8c\u6574,\u6ca1\u6709\u5b9a\u4e49\u5bf9\u5e94\u7684\u53d8\u91cf\u6570\u636e\u7c7b\u578b");
                }
                if (StringUtils.isBlank(batchDataResolverItemField.getDestProperty())) {
                    throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u7684\u6570\u636e\u6620\u5c04\u5b9a\u4e49\u4e0d\u5b8c\u6574,\u6ca1\u6709\u5b9a\u4e49\u5bf9\u5e94\u7684\u5b57\u6bb5\u540d");
                }
                if (!batchDataResolverItemField.isKey()) continue;
                bl = true;
            }
            if (batchDataResolverItem.getUpdateMode() != BatchUpdateMode.update && batchDataResolverItem.getUpdateMode() != BatchUpdateMode.delete || bl) continue;
            throw new RuleException("\u6570\u636e\u66f4\u65b0\u9879\u3010" + batchDataResolverItem.getName() + "\u3011\u6570\u636e\u6620\u5c04\u914d\u7f6e\u4e2d\u672a\u5b9a\u4e49\u4e3b\u952e");
        }
    }

    @Override
    public Batch getBatchData(Long l) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Batch batch = BatchManager.ins.get(l);
        if (StringUtils.isNotBlank(batch.getInputData())) {
            try {
                object4 = (List)JsonUtils.getObjectJsonMapper().readValue(batch.getInputData(), (TypeReference)new TypeReference<List<DataParam>>(){});
                batch.setParams((List<DataParam>)object4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank(batch.getPacketInputData())) {
            try {
                object4 = (List)JsonUtils.getObjectJsonMapper().readValue(batch.getPacketInputData(), (TypeReference)new TypeReference<List<DataParam>>(){});
                batch.setPacketParams((List<DataParam>)object4);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (DataParam)object3.next();
                    if (((DataParam)object2).getDataProviderId() == null || ((DataParam)object2).getDataProviderId() <= 0L || (object = this.getProviderData(((DataParam)object2).getDataProviderId())) == null) continue;
                    ((DataParam)object2).setDataProvider((BatchDataProvider)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (batch.getPacketId() != null && batch.getPacketId() > 0L && (object4 = PacketManager.ins.load(batch.getPacketId())) != null) {
            batch.setPacketName(((Packet)object4).getName());
        }
        object4 = this.getProviderData(batch.getProviderId());
        batch.setDataProvider((BatchDataProvider)object4);
        object3 = ResolverManager.ins.get(batch.getResolverId());
        object2 = ResolverItemManager.ins.createQuery();
        object = object2.resolverId(((BatchDataResolver)object3).getId()).list();
        Object object5 = object.iterator();
        while (object5.hasNext()) {
            List<DataParam> list;
            BatchDataResolverItem batchDataResolverItem = object5.next();
            ResolverFieldQuery resolverFieldQuery = ResolverFieldManager.ins.createQuery();
            List<BatchDataResolverItemField> list2 = resolverFieldQuery.itemId(batchDataResolverItem.getId()).list();
            batchDataResolverItem.setFields(list2);
            if (StringUtils.isNotBlank(batchDataResolverItem.getFilterData())) {
                try {
                    list = (List)JsonUtils.getObjectJsonMapper().readValue(batchDataResolverItem.getFilterData(), (TypeReference)new TypeReference<List<Filter>>(){});
                    for (Filter filter : list) {
                        List<FilterItem> list3 = filter.getItems();
                        for (FilterItem filterItem : list3) {
                            String string = filterItem.getValue();
                            if (StringUtils.isBlank(string)) continue;
                            if (filterItem.getType() == FilterType.bean) {
                                filterItem.setItemObject(Utils.getApplicationContext().getBean(string));
                                continue;
                            }
                            if (filterItem.getType() != FilterType.property) continue;
                            PropertyFilter propertyFilter = (PropertyFilter)JsonUtils.getObjectJsonMapper().readValue(string, PropertyFilter.class);
                            filterItem.setItemObject(propertyFilter);
                        }
                    }
                    batchDataResolverItem.setFilters(list);
                }
                catch (Exception exception) {
                    a.error((Object)exception);
                }
            }
            list = new ArrayList();
            Object object7 = null;
            BatchUpdateMode object62 = batchDataResolverItem.getUpdateMode();
            if (BatchUpdateMode.insert == object62) {
                object7 = this.c(list, batchDataResolverItem);
            } else if (BatchUpdateMode.update == object62) {
                object7 = this.b(list, batchDataResolverItem);
            } else if (BatchUpdateMode.delete == object62) {
                object7 = this.a(list, batchDataResolverItem);
            }
            batchDataResolverItem.setUpdateSql((String)object7);
            batchDataResolverItem.setParams(list);
        }
        ((BatchDataResolver)object3).setItems((List<BatchDataResolverItem>)object);
        object5 = DataSourceManager.ins.get(((BatchDataResolver)object3).getDatasourceId());
        ((BatchDataResolver)object3).setDatasource((DataSource)object5);
        batch.setDataResolver((BatchDataResolver)object3);
        return batch;
    }

    @Override
    public BatchDataProvider getProviderData(Long l) {
        List list;
        BatchDataProvider batchDataProvider = ProviderManager.ins.get(l);
        DataSource dataSource = DataSourceManager.ins.get(batchDataProvider.getDatasourceId());
        batchDataProvider.setDatasource(dataSource);
        ProviderFieldQuery providerFieldQuery = ProviderFieldManager.ins.createQuery();
        if (StringUtils.isNotBlank(batchDataProvider.getInputData())) {
            try {
                list = (List)JsonUtils.getObjectJsonMapper().readValue(batchDataProvider.getInputData(), (TypeReference)new TypeReference<List<DataParam>>(){});
                batchDataProvider.setParams(list);
            }
            catch (Exception exception) {
                a.error((Object)exception);
            }
        }
        list = providerFieldQuery.providerId(batchDataProvider.getId()).list();
        for (BatchDataProviderField batchDataProviderField : list) {
            BatchDataProvider batchDataProvider2;
            if (batchDataProviderField.getDataProviderId() == null || batchDataProviderField.getDataProviderId() <= 0L || (batchDataProvider2 = this.getProviderData(batchDataProviderField.getDataProviderId())) == null) continue;
            batchDataProviderField.setDataProvider(batchDataProvider2);
        }
        batchDataProvider.setFields(list);
        return batchDataProvider;
    }

    protected String a(List<DataParam> list, BatchDataResolverItem batchDataResolverItem) {
        String string = batchDataResolverItem.getTableName();
        List<BatchDataResolverItemField> list2 = batchDataResolverItem.getFields();
        String string2 = "delete from " + string + " where ";
        String string3 = "";
        for (BatchDataResolverItemField batchDataResolverItemField : list2) {
            if (!batchDataResolverItemField.isKey()) continue;
            if (StringUtils.isNotEmpty(string3)) {
                string3 = string3 + ", ";
            }
            string3 = string3 + batchDataResolverItemField.getDestProperty() + "=? ";
            DataParam dataParam = new DataParam();
            dataParam.setDataType(batchDataResolverItemField.getDataType());
            dataParam.setName(batchDataResolverItemField.getSrcProperty());
            dataParam.setIndex(list.size());
            list.add(dataParam);
        }
        string2 = string2 + string3;
        return string2;
    }

    protected String b(List<DataParam> list, BatchDataResolverItem batchDataResolverItem) {
        DataParam dataParam;
        String string = batchDataResolverItem.getTableName();
        List<BatchDataResolverItemField> list2 = batchDataResolverItem.getFields();
        String string2 = "update " + string + " set ";
        String string3 = "";
        String string4 = "";
        for (BatchDataResolverItemField batchDataResolverItemField : list2) {
            if (batchDataResolverItemField.isKey()) continue;
            if (StringUtils.isNotEmpty(string3)) {
                string3 = string3 + ", ";
            }
            string3 = string3 + batchDataResolverItemField.getDestProperty() + "=? ";
            dataParam = new DataParam();
            dataParam.setDataType(batchDataResolverItemField.getDataType());
            dataParam.setName(batchDataResolverItemField.getSrcProperty());
            dataParam.setIndex(list.size());
            list.add(dataParam);
        }
        for (BatchDataResolverItemField batchDataResolverItemField : list2) {
            if (!batchDataResolverItemField.isKey()) continue;
            if (StringUtils.isNotEmpty(string4)) {
                string4 = string4 + ", ";
            }
            string4 = string4 + batchDataResolverItemField.getDestProperty() + "=? ";
            dataParam = new DataParam();
            dataParam.setDataType(batchDataResolverItemField.getDataType());
            dataParam.setName(batchDataResolverItemField.getSrcProperty());
            dataParam.setIndex(list.size());
            list.add(dataParam);
        }
        if (StringUtils.isNotBlank(string4)) {
            string4 = " where " + string4;
        }
        string2 = string2 + string3 + string4;
        return string2;
    }

    protected String c(List<DataParam> list, BatchDataResolverItem batchDataResolverItem) {
        String string = batchDataResolverItem.getTableName();
        List<BatchDataResolverItemField> list2 = batchDataResolverItem.getFields();
        String string2 = "insert into " + string + " ";
        String string3 = "";
        String string4 = "";
        for (BatchDataResolverItemField batchDataResolverItemField : list2) {
            if (StringUtils.isNotEmpty(string3)) {
                string3 = string3 + ", ";
                string4 = string4 + ", ";
            }
            string3 = string3 + batchDataResolverItemField.getDestProperty();
            string4 = string4 + "?";
            DataParam dataParam = new DataParam();
            dataParam.setDataType(batchDataResolverItemField.getDataType());
            dataParam.setName(batchDataResolverItemField.getSrcProperty());
            dataParam.setIndex(list.size());
            list.add(dataParam);
        }
        string2 = string2 + "(" + string3 + ") values (" + string4 + ")";
        return string2;
    }

    @Override
    public void stop(Long l, String string) {
        BatchManager.ins.updateStatus(l, BatchStatus.stop);
    }
}

