/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.inspector;

import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.inspector.BatchListener;
import com.bstek.urule.console.database.model.batch.Batch;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AuthorizationBatchListener
implements BatchListener {
    private static final String a = "urule_authorization";

    @Override
    public void beforeExecute(BatchContext batchContext) {
        HttpServletRequest httpServletRequest = RequestHolder.getRequest();
        if (httpServletRequest != null) {
            batchContext.getParamValueMap().put(a, httpServletRequest.getHeader("Authorization"));
        }
    }

    @Override
    public void onExecute(BatchContext batchContext) {
        Batch batch = batchContext.getBatch();
        BatchResult batchResult = batchContext.getResult();
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set("Authorization", (String)batchContext.getParamValueMap().get(a));
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity httpEntity = new HttpEntity((Object)batchResult, (MultiValueMap)httpHeaders);
            restTemplate.postForLocation(batch.getCallbackUrl(), (Object)httpEntity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

