/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.service;

import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchItemResult;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.processor.DefaultRuleProcessor;
import com.bstek.urule.console.batch.processor.RuleProcessor;
import com.bstek.urule.console.batch.reader.DefaultItemReader;
import com.bstek.urule.console.batch.reader.ItemReader;
import com.bstek.urule.console.batch.service.BatchService;
import com.bstek.urule.console.database.manager.batch.BatchManager;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataProvider;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.console.database.service.repository.DataSourceHandlerManager;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.GeneralEntity;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBatchService
implements BatchService {
    private static Log a = LogFactory.getLog(AbstractBatchService.class);
    private static ItemReader b;
    private static RuleProcessor c;

    private ItemReader b() {
        if (b == null) {
            b = new DefaultItemReader();
        }
        return b;
    }

    protected RuleProcessor a() {
        if (c == null) {
            c = new DefaultRuleProcessor();
        }
        return c;
    }

    protected boolean a(BatchContext batchContext) {
        Batch batch = batchContext.getBatch();
        BatchResult batchResult = batchContext.getResult();
        try {
            int n = this.getTotleRows(batch.getDataProvider());
            batchContext.setReadCount(n);
            batchResult.setReadCount(n);
            if (n == 0) {
                batchResult.setStatus(BatchStatus.completed);
                batchResult.setMsg(BatchStatus.completed.name());
                return false;
            }
            int n2 = Double.valueOf(Math.ceil(Double.valueOf(n) / (double)this.a(batch))).intValue();
            batchContext.setPageCount(n2);
            if (batch.isThreadMulti()) {
                int n3 = Double.valueOf(Math.ceil(Double.valueOf(n) / (double)(batch.getThreadDataSize() * batch.getThreadSize()))).intValue();
                batchContext.setBatchCount(n3);
            }
            Connection connection = this.getReadDataSource(batchContext.getBatch()).getConnection();
            batchContext.setReadConnection(connection);
        }
        catch (Exception exception) {
            this.closeConnection(batchContext.getReadConnection());
            a.error((Object)exception);
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
            return false;
        }
        return true;
    }

    public void rollbackConnection(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new RuleException((Exception)sQLException);
        }
    }

    public void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuleException((Exception)sQLException);
        }
    }

    protected int a(Batch batch) {
        int n = 0;
        if (batch.isThreadMulti()) {
            n = batch.getThreadDataSize();
        } else if (batch.getDataProvider().isSupportsPaging().booleanValue()) {
            n = batch.getDataProvider().getPageSize();
        }
        if (n <= 0) {
            n = 100;
        }
        return n;
    }

    protected Map<String, BatchItemResult> a(BatchDataResolver batchDataResolver) {
        HashMap<String, BatchItemResult> hashMap = new HashMap<String, BatchItemResult>();
        for (BatchDataResolverItem batchDataResolverItem : batchDataResolver.getItems()) {
            String string = batchDataResolverItem.getName();
            BatchItemResult batchItemResult = new BatchItemResult();
            batchItemResult.setTableName(batchDataResolverItem.getTableName());
            batchItemResult.setUpdateMode(batchDataResolverItem.getUpdateMode());
            batchItemResult.setName(string);
            hashMap.put(string, batchItemResult);
        }
        return hashMap;
    }

    public int getTotleRows(BatchDataProvider batchDataProvider) throws Exception {
        return this.b().getTotleRows(batchDataProvider);
    }

    public List<GeneralEntity> loadDatas(Connection connection, BatchContext batchContext, int n) throws Exception {
        Batch batch = batchContext.getBatch();
        if (n >= 0) {
            int n2 = this.a(batch);
            return this.b().getPageDatas(connection, batchContext, n, n2);
        }
        return this.b().getDatas(connection, batchContext);
    }

    protected int a(BatchResult batchResult, Map<Integer, Integer> map) {
        Iterator<Integer> iterator = map.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += iterator.next().intValue();
        }
        return n;
    }

    protected void a(BatchResult batchResult, List<BatchResult> list) {
        for (BatchResult batchResult2 : list) {
            batchResult.setFilterCount(batchResult.getFilterCount() + batchResult2.getFilterCount());
        }
    }

    protected void a(Batch batch, BatchResult batchResult, Map<Integer, Map<String, BatchItemResult>> map) {
        for (BatchDataResolverItem batchDataResolverItem : batch.getDataResolver().getItems()) {
            String string = batchDataResolverItem.getName();
            BatchItemResult batchItemResult = null;
            if (batchResult.getItemResults().containsKey(string)) {
                batchItemResult = batchResult.getItemResults().get(string);
            } else {
                batchItemResult = new BatchItemResult();
                batchItemResult.setTableName(batchDataResolverItem.getTableName());
                batchItemResult.setUpdateMode(batchDataResolverItem.getUpdateMode());
                batchItemResult.setName(string);
                batchResult.getItemResults().put(string, batchItemResult);
            }
            for (Map<String, BatchItemResult> map2 : map.values()) {
                if (!map2.containsKey(string)) continue;
                BatchItemResult batchItemResult2 = map2.get(string);
                batchItemResult.setReadCount(batchItemResult.getReadCount() + batchItemResult2.getReadCount());
                batchItemResult.setWriteCount(batchItemResult.getWriteCount() + batchItemResult2.getWriteCount());
                batchItemResult.setFilterCount(batchItemResult.getFilterCount() + batchItemResult2.getFilterCount());
            }
        }
    }

    protected void a(Batch batch, BatchResult batchResult, List<BatchResult> list) {
        for (BatchDataResolverItem object : batch.getDataResolver().getItems()) {
            String string = object.getName();
            BatchItemResult batchItemResult = null;
            if (batchResult.getItemResults().containsKey(string)) {
                batchItemResult = batchResult.getItemResults().get(string);
            } else {
                batchItemResult = new BatchItemResult();
                batchItemResult.setTableName(object.getTableName());
                batchItemResult.setUpdateMode(object.getUpdateMode());
                batchItemResult.setName(string);
                batchResult.getItemResults().put(string, batchItemResult);
            }
            for (BatchResult batchResult2 : list) {
                if (!batchResult2.getItemResults().containsKey(string)) continue;
                BatchItemResult batchItemResult2 = batchResult2.getItemResults().get(string);
                batchItemResult.setReadCount(batchItemResult.getReadCount() + batchItemResult2.getReadCount());
                batchItemResult.setWriteCount(batchItemResult.getWriteCount() + batchItemResult2.getWriteCount());
                batchItemResult.setFilterCount(batchItemResult.getFilterCount() + batchItemResult2.getFilterCount());
            }
        }
        List<Exception> list2 = batchResult.getExceptions();
        if (list2 == null) {
            list2 = new ArrayList<Exception>();
        }
        for (BatchResult batchResult3 : list) {
            list2.addAll(batchResult3.getExceptions());
        }
        batchResult.setExceptions(list2);
    }

    public DataSource getReadDataSource(Batch batch) throws Exception {
        return DataSourceHandlerManager.getDataSource(batch.getDataProvider().getDatasource());
    }

    public DataSource getWriteDataSource(Batch batch) throws Exception {
        return DataSourceHandlerManager.getDataSource(batch.getDataResolver().getDatasource());
    }

    public BatchStatus getBatchStatus(Long l) {
        Batch batch = BatchManager.ins.get(l);
        return batch.getStatus();
    }
}

