/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.service;

import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchItemResult;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.service.AbstractBatchTranService;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.TranScope;
import com.bstek.urule.model.GeneralEntity;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicBatchService
extends AbstractBatchTranService {
    private static Log a = LogFactory.getLog(BasicBatchService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchContext batchContext) {
        Batch batch = batchContext.getBatch();
        BatchResult batchResult = batchContext.getResult();
        boolean bl = this.a(batchContext);
        if (!bl) {
            return;
        }
        try {
            if (batch.getDataProvider().isSupportsPaging().booleanValue()) {
                this.executeByPage(batchContext);
            } else {
                this.executeTotal(batchContext);
            }
        }
        catch (Exception exception) {
            a.error((Object)exception);
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
        }
        finally {
            this.closeConnection(batchContext.getReadConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeByPage(BatchContext batchContext) {
        BatchResult batchResult = batchContext.getResult();
        Connection connection = batchContext.getReadConnection();
        Batch batch = batchContext.getBatch();
        BatchDataResolver batchDataResolver = batch.getDataResolver();
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        if (batchDataResolver.getTranScope() == TranScope.batch && batchDataResolver.getDialect().supportTransaction()) {
            Map<String, Object> map = null;
            Map<String, BatchItemResult> map2 = null;
            map2 = this.a(batchDataResolver);
            batchResult.setItemResults(map2);
            Connection connection2 = null;
            try {
                connection2 = this.getWriteDataSource(batch).getConnection();
                connection2.setAutoCommit(false);
                map = this.a(connection2, batchDataResolver);
                int n = 0;
                BatchStatus batchStatus = BatchStatus.started;
                for (int i = 0; i < batchContext.getPageCount(); ++i) {
                    if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                        batchStatus = BatchStatus.stop;
                        break;
                    }
                    a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011loadData pageIndex:" + i + "..."));
                    try {
                        List<GeneralEntity> exception = this.loadDatas(connection, batchContext, i);
                        n += exception.size();
                        for (GeneralEntity generalEntity : exception) {
                            this.a(batchContext, connection2, map, generalEntity, map2);
                        }
                        this.b(map);
                        continue;
                    }
                    catch (Exception object2) {
                        a.error((Object)object2);
                        arrayList.add(object2);
                        if (batch.getSkipLimit() > 0) {
                            if (batch.getSkipLimit() >= arrayList.size()) continue;
                            throw object2;
                        }
                        throw object2;
                    }
                }
                if (batchStatus != BatchStatus.stop) {
                    batchResult.setFilterCount(batchResult.getReadCount() - n);
                    a.debug((Object)("commit batch \u3010" + batch.getName() + "\u3011....."));
                    connection2.commit();
                    a.debug((Object)("commit batch \u3010" + batch.getName() + "\u3011 success"));
                    this.a(map);
                    for (BatchItemResult batchItemResult : map2.values()) {
                        batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                    }
                    batchResult.setStatus(BatchStatus.completed);
                    batchResult.setMsg(BatchStatus.completed.name());
                }
                this.rollbackConnection(connection2);
                batchResult.setStatus(BatchStatus.stop);
            }
            catch (Exception exception) {
                a.error((Object)exception);
                this.a(map);
                this.rollbackConnection(connection2);
                for (BatchItemResult batchItemResult : map2.values()) {
                    batchItemResult.setWriteCount(0);
                }
                batchResult.setStatus(BatchStatus.failed);
                batchResult.setException(exception);
            }
            finally {
                batchResult.setExceptions(arrayList);
                this.closeConnection(connection2);
            }
        } else if (batchDataResolver.getTranScope() == TranScope.page && batchDataResolver.getDialect().supportTransaction()) {
            HashMap<Integer, Map<String, BatchItemResult>> hashMap = new HashMap<Integer, Map<String, BatchItemResult>>();
            int n = 0;
            Connection connection3 = null;
            try {
                int n2;
                connection3 = this.getWriteDataSource(batch).getConnection();
                connection3.setAutoCommit(false);
                BatchStatus batchStatus = batch.getStatus();
                for (n2 = 0; n2 < batchContext.getPageCount(); ++n2) {
                    Object object = null;
                    Map<String, BatchItemResult> map = this.a(batchDataResolver);
                    hashMap.put(n2, map);
                    object = this.a(connection3, batchDataResolver);
                    try {
                        if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                            batchStatus = BatchStatus.stop;
                            break;
                        }
                        a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011loadData pageIndex:" + n2 + "..."));
                        List<GeneralEntity> list = this.loadDatas(connection, batchContext, n2);
                        n += list.size();
                        for (GeneralEntity generalEntity : list) {
                            this.a(batchContext, connection3, (Map<String, Object>)object, generalEntity, map);
                        }
                        this.b((Map<String, Object>)object);
                        connection3.commit();
                        for (BatchItemResult batchItemResult : map.values()) {
                            batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        a.error((Object)exception);
                        arrayList.add(exception);
                        this.rollbackConnection(connection3);
                        for (BatchItemResult batchItemResult : map.values()) {
                            batchItemResult.setWriteCount(0);
                        }
                        if (batch.getSkipLimit() > 0) {
                            if (batch.getSkipLimit() >= arrayList.size()) continue;
                            throw exception;
                        }
                        throw exception;
                    }
                    finally {
                        this.a((Map<String, Object>)object);
                    }
                }
                if (batchStatus != BatchStatus.stop) {
                    batchResult.setFilterCount(batchResult.getReadCount() - n);
                    this.a(batch, batchResult, hashMap);
                    n2 = 0;
                    for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                        if (batchItemResult.getWriteCount() <= 0) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) {
                        batchResult.setStatus(BatchStatus.completed);
                        batchResult.setMsg(BatchStatus.completed.name());
                    }
                    batchResult.setStatus(BatchStatus.failed);
                }
                batchResult.setStatus(BatchStatus.stop);
            }
            catch (Exception exception) {
                a.error((Object)exception);
                batchResult.setStatus(BatchStatus.failed);
                batchResult.setException(exception);
            }
            finally {
                batchResult.setExceptions(arrayList);
                this.closeConnection(connection3);
            }
        } else {
            ArrayList<BatchResult> arrayList2 = new ArrayList<BatchResult>();
            Connection connection4 = null;
            try {
                int n;
                int n3 = 0;
                connection4 = this.getWriteDataSource(batch).getConnection();
                BatchStatus batchStatus = batch.getStatus();
                for (n = 0; n < batchContext.getPageCount(); ++n) {
                    if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                        batchStatus = BatchStatus.stop;
                        break;
                    }
                    a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011pageIndex:" + n));
                    BatchResult batchResult2 = new BatchResult();
                    arrayList2.add(batchResult2);
                    a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011loadData pageIndex:" + n + "..."));
                    List<GeneralEntity> list = this.loadDatas(connection, batchContext, n);
                    n3 += list.size();
                    HashMap<Integer, Map<String, BatchItemResult>> hashMap = new HashMap<Integer, Map<String, BatchItemResult>>();
                    for (int i = 0; i < list.size(); ++i) {
                        GeneralEntity generalEntity = list.get(i);
                        Map<String, Object> map = null;
                        Map<String, BatchItemResult> map2 = null;
                        map2 = this.a(batchDataResolver);
                        hashMap.put(i, map2);
                        try {
                            if (batchDataResolver.getDialect().supportTransaction()) {
                                connection4.setAutoCommit(false);
                            }
                            map = this.a(connection4, batchDataResolver);
                            this.a(batchContext, connection4, map, generalEntity, map2);
                            if (batchDataResolver.getDialect().supportTransaction()) {
                                this.b(map);
                                connection4.commit();
                            }
                            for (BatchItemResult batchItemResult : map2.values()) {
                                batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            a.error((Object)exception);
                            if (batchDataResolver.getDialect().supportTransaction()) {
                                this.rollbackConnection(connection4);
                            }
                            for (BatchItemResult batchItemResult : map2.values()) {
                                batchItemResult.setWriteCount(0);
                            }
                            batchResult.setException(exception);
                            arrayList.add(exception);
                            if (batch.getSkipLimit() > 0) {
                                if (batch.getSkipLimit() >= arrayList.size()) continue;
                                throw exception;
                            }
                            throw exception;
                        }
                        finally {
                            this.a(map);
                        }
                    }
                    this.a(batch, batchResult2, hashMap);
                }
                if (batchStatus != BatchStatus.stop) {
                    batchResult.setFilterCount(batchResult.getReadCount() - n3);
                    this.a(batch, batchResult, arrayList2);
                    n = 0;
                    for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                        if (batchItemResult.getWriteCount() <= 0) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) {
                        batchResult.setStatus(BatchStatus.completed);
                        batchResult.setMsg(BatchStatus.completed.name());
                    } else {
                        batchResult.setStatus(BatchStatus.failed);
                    }
                } else {
                    batchResult.setStatus(BatchStatus.stop);
                }
            }
            catch (Exception exception) {
                a.error((Object)exception);
                batchResult.setStatus(BatchStatus.failed);
                batchResult.setException(exception);
            }
            finally {
                batchResult.setExceptions(arrayList);
                this.closeConnection(connection4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void executeTotal(BatchContext batchContext) {
        BatchResult batchResult = batchContext.getResult();
        Batch batch = batchContext.getBatch();
        BatchDataResolver batchDataResolver = batch.getDataResolver();
        Map<String, Object> map = null;
        Map<String, BatchItemResult> map2 = null;
        List<GeneralEntity> list = null;
        try {
            a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011loadData ..."));
            list = this.loadDatas(batchContext.getReadConnection(), batchContext, -1);
            batchResult.setFilterCount(batchResult.getReadCount() - list.size());
            a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011data size:" + list.size()));
        }
        catch (Exception exception) {
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
            return;
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        if ((batchDataResolver.getTranScope() == TranScope.batch || batchDataResolver.getTranScope() == TranScope.page) && batchDataResolver.getDialect().supportTransaction()) {
            Connection connection = null;
            try {
                connection = this.getWriteDataSource(batch).getConnection();
                connection.setAutoCommit(false);
                map = this.a(connection, batchDataResolver);
                map2 = this.a(batchDataResolver);
                BatchStatus batchStatus = batch.getStatus();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        GeneralEntity exception = list.get(i);
                        if (i % 10000 == 0) {
                            if (a.isDebugEnabled()) {
                                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011record index: " + i + "..."));
                            }
                            if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                                batchStatus = BatchStatus.stop;
                                break;
                            }
                        }
                        this.a(batchContext, connection, map, exception, map2);
                        continue;
                    }
                    catch (Exception n) {
                        a.error((Object)n);
                        arrayList.add(n);
                        if (batch.getSkipLimit() > 0) {
                            if (batch.getSkipLimit() >= arrayList.size()) continue;
                            throw n;
                        }
                        throw n;
                    }
                }
                if (batchStatus != BatchStatus.stop) {
                    this.b(map);
                    connection.commit();
                    for (BatchItemResult batchItemResult : map2.values()) {
                        batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                    }
                    batchResult.setItemResults(map2);
                }
                this.rollbackConnection(connection);
                batchResult.setStatus(BatchStatus.stop);
            }
            catch (Exception exception) {
                batchResult.setStatus(BatchStatus.failed);
                batchResult.setException(exception);
            }
            finally {
                this.a(map);
                batchResult.setExceptions(arrayList);
                this.closeConnection(connection);
            }
        } else {
            HashMap<Integer, Map<String, BatchItemResult>> hashMap = new HashMap<Integer, Map<String, BatchItemResult>>();
            Connection connection = null;
            try {
                void var12_25;
                connection = this.getWriteDataSource(batch).getConnection();
                if (batchDataResolver.getDialect().supportTransaction()) {
                    connection.setAutoCommit(false);
                }
                BatchStatus batchStatus = batch.getStatus();
                boolean bl = false;
                while (var12_25 < list.size()) {
                    block45: {
                        GeneralEntity generalEntity = list.get((int)var12_25);
                        Map<String, BatchItemResult> map3 = this.a(batchDataResolver);
                        hashMap.put((int)var12_25, map3);
                        if (var12_25 % 10000 == false) {
                            if (a.isDebugEnabled()) {
                                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011record index: " + (int)var12_25 + "..."));
                            }
                            if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                                batchStatus = BatchStatus.stop;
                                break;
                            }
                        }
                        try {
                            map = this.a(connection, batchDataResolver);
                            this.a(batchContext, connection, map, generalEntity, map3);
                            if (batchDataResolver.getDialect().supportTransaction()) {
                                this.b(map);
                                connection.commit();
                            }
                            this.a(map);
                            for (Object object : map3.values()) {
                                ((BatchItemResult)object).setWriteCount(((BatchItemResult)object).getReadCount() - ((BatchItemResult)object).getFilterCount());
                            }
                        }
                        catch (Exception exception) {
                            Object object;
                            a.error((Object)exception);
                            if (batchDataResolver.getDialect().supportTransaction()) {
                                this.rollbackConnection(connection);
                            }
                            object = map3.values().iterator();
                            while (object.hasNext()) {
                                BatchItemResult batchItemResult = object.next();
                                batchItemResult.setWriteCount(0);
                            }
                            arrayList.add(exception);
                            if (batch.getSkipLimit() > 0) {
                                if (batch.getSkipLimit() < arrayList.size()) {
                                    throw exception;
                                }
                                break block45;
                            }
                            throw exception;
                        }
                        finally {
                            this.a(map);
                        }
                    }
                    ++var12_25;
                }
                this.closeConnection(connection);
                if (batchStatus != BatchStatus.stop) {
                    boolean bl2;
                    this.a(batch, batchResult, hashMap);
                    boolean bl3 = false;
                    for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                        if (batchItemResult.getWriteCount() <= 0) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        batchResult.setStatus(BatchStatus.completed);
                        batchResult.setMsg(BatchStatus.completed.name());
                    } else {
                        batchResult.setStatus(BatchStatus.failed);
                        batchResult.setMsg(BatchStatus.failed.name());
                    }
                } else {
                    batchResult.setStatus(BatchStatus.stop);
                }
            }
            catch (Exception exception) {
                batchResult.setStatus(BatchStatus.failed);
                batchResult.setException(exception);
            }
            finally {
                batchResult.setExceptions(arrayList);
                this.closeConnection(connection);
            }
        }
    }
}

