/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.service;

import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchItemResult;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.service.AbstractBatchTranService;
import com.bstek.urule.console.batch.service.MultiThreadUtils;
import com.bstek.urule.console.batch.service.RecordTranService;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.model.GeneralEntity;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchTranService
extends AbstractBatchTranService {
    private static Log a = LogFactory.getLog(RecordTranService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchContext batchContext) {
        Batch batch = batchContext.getBatch();
        BatchResult batchResult = batchContext.getResult();
        boolean bl = this.a(batchContext);
        if (!bl) {
            return;
        }
        Connection connection = null;
        ArrayList<BatchResult> arrayList = new ArrayList<BatchResult>();
        try {
            int n;
            connection = this.getWriteDataSource(batch).getConnection();
            connection.setAutoCommit(false);
            int n2 = 0;
            BatchStatus batchStatus = batch.getStatus();
            for (n = 0; n < batchContext.getBatchCount(); ++n) {
                if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                    batchStatus = BatchStatus.stop;
                    break;
                }
                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011batchIndex:" + n));
                Iterator<BatchItemResult> iterator = new BatchResult();
                ((BatchResult)((Object)iterator)).setStatus(BatchStatus.started);
                arrayList.add((BatchResult)((Object)iterator));
                this.executeSubBatch(connection, batchContext, n, (BatchResult)((Object)iterator));
                if (batch.getSkipLimit() > 0 && batch.getSkipLimit() < (n2 += ((BatchResult)((Object)iterator)).getExceptions().size())) break;
                ((BatchResult)((Object)iterator)).setStatus(BatchStatus.completed);
            }
            if (batchStatus != BatchStatus.stop) {
                this.a(batch, batchResult, arrayList);
                this.a(batchResult, arrayList);
                n = 1;
                for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                    if (batchItemResult.getReadCount() == batchItemResult.getWriteCount() + batchItemResult.getFilterCount()) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    a.debug((Object)("commit batch \u3010" + batch.getName() + "\u3011....."));
                    connection.commit();
                    a.debug((Object)("commit batch \u3010" + batch.getName() + "\u3011 success"));
                    batchResult.setStatus(BatchStatus.completed);
                    batchResult.setMsg(BatchStatus.completed.name());
                } else {
                    for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                        batchItemResult.setWriteCount(0);
                    }
                    if (connection != null) {
                        this.rollbackConnection(connection);
                    }
                    batchResult.setStatus(BatchStatus.failed);
                    batchResult.setMsg(BatchStatus.failed.name());
                }
            } else {
                batchResult.setStatus(BatchStatus.stop);
                if (connection != null) {
                    this.rollbackConnection(connection);
                }
            }
        }
        catch (Exception exception) {
            a.error((Object)exception);
            if (connection != null) {
                this.rollbackConnection(connection);
            }
            for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                batchItemResult.setWriteCount(0);
            }
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
        }
        finally {
            this.closeConnection(batchContext.getReadConnection());
            this.closeConnection(connection);
        }
    }

    public void executeSubBatch(Connection connection, final BatchContext batchContext, int n, BatchResult batchResult) {
        final Batch batch = batchContext.getBatch();
        int n2 = MultiThreadUtils.getThreadSize(n, batchContext);
        Thread[] threadArray = new Thread[n2];
        final CountDownLatch countDownLatch = new CountDownLatch(n2);
        final ConcurrentHashMap<Integer, Map<String, BatchItemResult>> concurrentHashMap = new ConcurrentHashMap<Integer, Map<String, BatchItemResult>>();
        final ConcurrentHashMap<Integer, Integer> concurrentHashMap2 = new ConcurrentHashMap<Integer, Integer>();
        final List<Exception> list = Collections.synchronizedList(new ArrayList());
        batchResult.setExceptions(list);
        for (int i = 0; i < n2; ++i) {
            final Connection connection2 = connection;
            final BatchDataResolver batchDataResolver = batch.getDataResolver();
            final int n3 = i + batch.getThreadSize() * n;
            threadArray[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map<String, Object> map = null;
                    Map<String, BatchItemResult> map2 = BatchTranService.this.a(batchDataResolver);
                    concurrentHashMap.put(n3, map2);
                    try {
                        a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011 pageIndex:" + n3 + "..."));
                        List<GeneralEntity> list2 = BatchTranService.this.loadDatas(batchContext.getReadConnection(), batchContext, n3);
                        concurrentHashMap2.put(n3, list2.size());
                        map = BatchTranService.this.a(connection2, batchDataResolver);
                        for (GeneralEntity object : list2) {
                            BatchTranService.this.a(batchContext, connection2, map, object, map2);
                        }
                        BatchTranService.this.b(map);
                        for (BatchItemResult batchItemResult : map2.values()) {
                            batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                        }
                    }
                    catch (Exception exception) {
                        a.error((Object)exception);
                        list.add(exception);
                        for (BatchItemResult batchItemResult : map2.values()) {
                            batchItemResult.setWriteCount(0);
                        }
                    }
                    finally {
                        BatchTranService.this.a(map);
                    }
                    countDownLatch.countDown();
                }
            });
            threadArray[i].start();
        }
        try {
            countDownLatch.await();
            this.a(batch, batchResult, concurrentHashMap);
            this.a(batchResult, concurrentHashMap2);
            batchResult.setStatus(BatchStatus.completed);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(interruptedException);
        }
    }
}

