/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.service;

import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchItemResult;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.HiveStatement;
import com.bstek.urule.console.batch.service.HiveTranService;
import com.bstek.urule.console.batch.service.MultiThreadUtils;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.model.GeneralEntity;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HiveBatchTranService
extends HiveTranService {
    private static Log a = LogFactory.getLog(HiveBatchTranService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchContext batchContext) {
        block20: {
            Batch batch = batchContext.getBatch();
            BatchResult batchResult = batchContext.getResult();
            boolean bl = this.a(batchContext);
            if (!bl) {
                return;
            }
            Connection connection = null;
            Statement statement = null;
            try {
                ArrayList<BatchResult> arrayList = new ArrayList<BatchResult>();
                int n = 0;
                BatchStatus batchStatus = batch.getStatus();
                BatchDataResolver batchDataResolver = batch.getDataResolver();
                Map<String, BatchItemResult> map = this.a(batchDataResolver);
                connection = this.getWriteDataSource(batch).getConnection();
                statement = connection.createStatement();
                Map<String, Object> map2 = this.b(batchDataResolver);
                for (int i = 0; i < batchContext.getBatchCount(); ++i) {
                    if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                        batchStatus = BatchStatus.stop;
                        break;
                    }
                    a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011batchIndex:" + i));
                    BatchResult batchResult2 = new BatchResult();
                    batchResult2.setStatus(BatchStatus.started);
                    this.executeSubBatch(batchContext, i, batchResult2, map2);
                    arrayList.add(batchResult2);
                    try {
                        this.a(statement, map2, batchDataResolver, map, false);
                    }
                    catch (Exception exception) {
                        a.error((Object)exception);
                        exception.printStackTrace();
                        batchResult.setException(exception);
                        batchResult2.getExceptions().add(exception);
                        if (batch.getSkipLimit() > 0) {
                            if (batch.getSkipLimit() >= batchResult2.getExceptions().size()) continue;
                            throw exception;
                        }
                        throw exception;
                    }
                    if (batch.getSkipLimit() > 0 && batch.getSkipLimit() < (n += batchResult2.getExceptions().size())) break;
                }
                try {
                    this.a(statement, map2, batchDataResolver, map, true);
                }
                catch (Exception exception) {
                    a.error((Object)exception);
                    exception.printStackTrace();
                    batchResult.setException(exception);
                    ++n;
                    if (batch.getSkipLimit() > 0) {
                        if (batch.getSkipLimit() < n) {
                            throw exception;
                        }
                    }
                    throw exception;
                }
                if (batchStatus != BatchStatus.stop) {
                    this.a(batch, batchResult, arrayList);
                    this.a(batchResult, arrayList);
                    this.b(batch, batchResult, map);
                    boolean bl2 = false;
                    for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                        if (batchItemResult.getReadCount() <= 0 || batchItemResult.getWriteCount() <= 0 && batchItemResult.getFilterCount() != batchItemResult.getReadCount()) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        batchResult.setStatus(BatchStatus.completed);
                        batchResult.setMsg(BatchStatus.completed.name());
                    } else {
                        batchResult.setStatus(BatchStatus.failed);
                        batchResult.setMsg(BatchStatus.failed.name());
                    }
                    a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011" + (Object)((Object)batchResult.getStatus()) + ":" + batchResult.getMsg()));
                } else {
                    batchResult.setStatus(BatchStatus.stop);
                }
                JdbcUtils.closeStatement(statement);
            }
            catch (Exception exception) {
                a.error((Object)exception);
                exception.printStackTrace();
                batchResult.setStatus(BatchStatus.failed);
                batchResult.setException(exception);
                break block20;
            }
            finally {
                JdbcUtils.closeStatement(statement);
                this.closeConnection(connection);
                this.closeConnection(batchContext.getReadConnection());
            }
            this.closeConnection(connection);
            this.closeConnection(batchContext.getReadConnection());
        }
    }

    public void executeSubBatch(final BatchContext batchContext, int n, BatchResult batchResult, Map<String, Object> map) {
        final Batch batch = batchContext.getBatch();
        int n2 = MultiThreadUtils.getThreadSize(n, batchContext);
        Thread[] threadArray = new Thread[n2];
        final CountDownLatch countDownLatch = new CountDownLatch(n2);
        final List<BatchResult> list = Collections.synchronizedList(new ArrayList());
        final ConcurrentHashMap<Integer, Integer> concurrentHashMap = new ConcurrentHashMap<Integer, Integer>();
        final List<Exception> list2 = Collections.synchronizedList(new ArrayList());
        final List<Map> list3 = Collections.synchronizedList(new ArrayList());
        batchResult.setExceptions(list2);
        final BatchDataResolver batchDataResolver = batch.getDataResolver();
        for (int i = 0; i < n2; ++i) {
            final int n3 = i + batch.getThreadSize() * n;
            threadArray[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BatchResult batchResult = new BatchResult();
                    list.add(batchResult);
                    HashMap<Integer, Map<String, BatchItemResult>> hashMap = new HashMap<Integer, Map<String, BatchItemResult>>();
                    try {
                        a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011 pageIndex:" + n3 + "..."));
                        List<GeneralEntity> list4 = HiveBatchTranService.this.loadDatas(batchContext.getReadConnection(), batchContext, n3);
                        concurrentHashMap.put(n3, list4.size());
                        Map<String, Object> map = HiveBatchTranService.this.b(batchDataResolver);
                        list3.add(map);
                        for (int i = 0; i < list4.size(); ++i) {
                            GeneralEntity generalEntity = list4.get(i);
                            Map<String, BatchItemResult> map2 = HiveBatchTranService.this.a(batchDataResolver);
                            hashMap.put(i, map2);
                            try {
                                HiveBatchTranService.this.a(batchContext, map, generalEntity, map2);
                                continue;
                            }
                            catch (Exception exception) {
                                a.error((Object)exception);
                                list2.add(exception);
                                if (batch.getSkipLimit() > 0) {
                                    if (batch.getSkipLimit() >= list2.size()) continue;
                                    throw exception;
                                }
                                throw exception;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        HiveBatchTranService.this.a(batch, batchResult, hashMap);
                    }
                    countDownLatch.countDown();
                }
            });
            threadArray[i].start();
        }
        try {
            countDownLatch.await();
            this.a(batch, batchResult, list);
            this.a(batchResult, concurrentHashMap);
            for (Map map2 : list3) {
                for (String string : map.keySet()) {
                    HiveStatement hiveStatement = (HiveStatement)map2.get(string);
                    HiveStatement hiveStatement2 = (HiveStatement)map.get(string);
                    List<String> list4 = hiveStatement2.getBatchSqls();
                    list4.addAll(hiveStatement.getBatchSqls());
                    hiveStatement2.setBatchSqls(list4);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(interruptedException);
        }
    }
}

