/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.service;

import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchItemResult;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.service.AbstractBatchTranService;
import com.bstek.urule.console.batch.service.MultiThreadUtils;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.model.GeneralEntity;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageTranService
extends AbstractBatchTranService {
    private static Log a = LogFactory.getLog(PageTranService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchContext batchContext) {
        Batch batch = batchContext.getBatch();
        BatchResult batchResult = batchContext.getResult();
        boolean bl = this.a(batchContext);
        if (!bl) {
            return;
        }
        try {
            int n;
            ArrayList<BatchResult> arrayList = new ArrayList<BatchResult>();
            int n2 = 0;
            BatchStatus batchStatus = batch.getStatus();
            for (n = 0; n < batchContext.getBatchCount(); ++n) {
                if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                    batchStatus = BatchStatus.stop;
                    break;
                }
                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011btachIndex:" + n));
                BatchResult batchResult2 = new BatchResult();
                batchResult2.setStatus(BatchStatus.started);
                this.executeSubBatch(this.getWriteDataSource(batch), batchContext, n, batchResult2);
                arrayList.add(batchResult2);
                if (batch.getSkipLimit() > 0 && batch.getSkipLimit() < (n2 += batchResult2.getExceptions().size())) break;
            }
            if (batchStatus != BatchStatus.stop) {
                this.a(batch, batchResult, arrayList);
                this.a(batchResult, arrayList);
                n = 0;
                for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                    if (batchItemResult.getReadCount() <= 0 || batchItemResult.getWriteCount() <= 0 && batchItemResult.getFilterCount() != batchItemResult.getReadCount()) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    batchResult.setStatus(BatchStatus.completed);
                    batchResult.setMsg(BatchStatus.completed.name());
                } else {
                    batchResult.setStatus(BatchStatus.failed);
                    batchResult.setMsg(BatchStatus.failed.name());
                }
                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011" + (Object)((Object)batchResult.getStatus()) + ":" + batchResult.getMsg()));
            } else {
                batchResult.setStatus(BatchStatus.stop);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
        }
        finally {
            this.closeConnection(batchContext.getReadConnection());
        }
    }

    public void executeSubBatch(final DataSource dataSource, final BatchContext batchContext, int n, BatchResult batchResult) {
        final Batch batch = batchContext.getBatch();
        int n2 = MultiThreadUtils.getThreadSize(n, batchContext);
        Thread[] threadArray = new Thread[n2];
        final CountDownLatch countDownLatch = new CountDownLatch(n2);
        final ConcurrentHashMap<Integer, Map<String, BatchItemResult>> concurrentHashMap = new ConcurrentHashMap<Integer, Map<String, BatchItemResult>>();
        final ConcurrentHashMap<Integer, Integer> concurrentHashMap2 = new ConcurrentHashMap<Integer, Integer>();
        final List<Exception> list = Collections.synchronizedList(new ArrayList());
        batchResult.setExceptions(list);
        for (int i = 0; i < n2; ++i) {
            final BatchDataResolver batchDataResolver = batch.getDataResolver();
            final int n3 = i + batch.getThreadSize() * n;
            threadArray[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Connection connection = null;
                    Map<String, Object> map = null;
                    Map<String, BatchItemResult> map2 = PageTranService.this.a(batchDataResolver);
                    concurrentHashMap.put(n3, map2);
                    try {
                        connection = dataSource.getConnection();
                        a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011 pageIndex:" + n3 + "..."));
                        List<GeneralEntity> list2 = PageTranService.this.loadDatas(batchContext.getReadConnection(), batchContext, n3);
                        concurrentHashMap2.put(n3, list2.size());
                        connection.setAutoCommit(false);
                        map = PageTranService.this.a(connection, batchDataResolver);
                        for (GeneralEntity object : list2) {
                            PageTranService.this.a(batchContext, connection, map, object, map2);
                        }
                        PageTranService.this.b(map);
                        connection.commit();
                        for (BatchItemResult batchItemResult : map2.values()) {
                            batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                        }
                    }
                    catch (Exception exception) {
                        a.error((Object)exception);
                        PageTranService.this.rollbackConnection(connection);
                        list.add(exception);
                        for (BatchItemResult batchItemResult : map2.values()) {
                            batchItemResult.setWriteCount(0);
                        }
                    }
                    finally {
                        PageTranService.this.a(map);
                        PageTranService.this.closeConnection(connection);
                    }
                    countDownLatch.countDown();
                }
            });
            threadArray[i].start();
        }
        try {
            countDownLatch.await();
            this.a(batch, batchResult, concurrentHashMap);
            this.a(batchResult, concurrentHashMap2);
            batchResult.setStatus(BatchStatus.completed);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(interruptedException);
        }
    }
}

