/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.service;

import com.bstek.urule.console.batch.BatchContext;
import com.bstek.urule.console.batch.BatchItemResult;
import com.bstek.urule.console.batch.BatchResult;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.service.AbstractBatchTranService;
import com.bstek.urule.console.batch.service.BatchTranService;
import com.bstek.urule.console.batch.service.MultiThreadUtils;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.model.GeneralEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordTranService
extends AbstractBatchTranService {
    private static Log a = LogFactory.getLog(BatchTranService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchContext batchContext) {
        Batch batch = batchContext.getBatch();
        BatchResult batchResult = batchContext.getResult();
        boolean bl = this.a(batchContext);
        if (!bl) {
            return;
        }
        try {
            int n;
            ArrayList<BatchResult> arrayList = new ArrayList<BatchResult>();
            int n2 = 0;
            BatchStatus batchStatus = batch.getStatus();
            for (n = 0; n < batchContext.getBatchCount(); ++n) {
                if (this.getBatchStatus(batch.getId()) == BatchStatus.stop) {
                    batchStatus = BatchStatus.stop;
                    break;
                }
                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011batchIndex:" + n));
                BatchResult batchResult2 = new BatchResult();
                batchResult2.setStatus(BatchStatus.started);
                this.executeSubBatch(batchContext, n, batchResult2);
                arrayList.add(batchResult2);
                if (batch.getSkipLimit() > 0 && batch.getSkipLimit() < (n2 += batchResult2.getExceptions().size())) break;
            }
            if (batchStatus != BatchStatus.stop) {
                this.a(batch, batchResult, arrayList);
                this.a(batchResult, arrayList);
                n = 0;
                for (BatchItemResult batchItemResult : batchResult.getItemResults().values()) {
                    if (batchItemResult.getReadCount() <= 0 || batchItemResult.getWriteCount() <= 0 && batchItemResult.getFilterCount() != batchItemResult.getReadCount()) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    batchResult.setStatus(BatchStatus.completed);
                    batchResult.setMsg(BatchStatus.completed.name());
                } else {
                    batchResult.setStatus(BatchStatus.failed);
                    batchResult.setMsg(BatchStatus.failed.name());
                }
                a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011" + (Object)((Object)batchResult.getStatus()) + ":" + batchResult.getMsg()));
            } else {
                batchResult.setStatus(BatchStatus.stop);
            }
        }
        catch (Exception exception) {
            a.error((Object)exception);
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(exception);
        }
        finally {
            this.closeConnection(batchContext.getReadConnection());
        }
    }

    public void executeSubBatch(final BatchContext batchContext, int n, BatchResult batchResult) {
        final Batch batch = batchContext.getBatch();
        int n2 = MultiThreadUtils.getThreadSize(n, batchContext);
        Thread[] threadArray = new Thread[n2];
        final CountDownLatch countDownLatch = new CountDownLatch(n2);
        final List<BatchResult> list = Collections.synchronizedList(new ArrayList());
        final ConcurrentHashMap<Integer, Integer> concurrentHashMap = new ConcurrentHashMap<Integer, Integer>();
        final List<Exception> list2 = Collections.synchronizedList(new ArrayList());
        batchResult.setExceptions(list2);
        for (int i = 0; i < n2; ++i) {
            final int n3 = i + batch.getThreadSize() * n;
            threadArray[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BatchDataResolver batchDataResolver = batch.getDataResolver();
                    BatchResult batchResult = new BatchResult();
                    list.add(batchResult);
                    HashMap<Integer, Map<String, BatchItemResult>> hashMap = new HashMap<Integer, Map<String, BatchItemResult>>();
                    try {
                        a.debug((Object)("execute batch \u3010" + batch.getName() + "\u3011 pageIndex:" + n3 + "..."));
                        List<GeneralEntity> list3 = RecordTranService.this.loadDatas(batchContext.getReadConnection(), batchContext, n3);
                        concurrentHashMap.put(n3, list3.size());
                        for (int i = 0; i < list3.size(); ++i) {
                            GeneralEntity generalEntity = list3.get(i);
                            Map<String, Object> map = null;
                            Map<String, BatchItemResult> map2 = RecordTranService.this.a(batchDataResolver);
                            hashMap.put(i, map2);
                            Connection connection = null;
                            try {
                                connection = RecordTranService.this.getWriteDataSource(batch).getConnection();
                                if (batchDataResolver.getDialect().supportTransaction()) {
                                    connection.setAutoCommit(false);
                                }
                                map = RecordTranService.this.a(connection, batchDataResolver);
                                RecordTranService.this.a(batchContext, connection, map, generalEntity, map2);
                                if (batchDataResolver.getDialect().supportTransaction()) {
                                    RecordTranService.this.b(map);
                                    connection.commit();
                                }
                                for (BatchItemResult batchItemResult : map2.values()) {
                                    batchItemResult.setWriteCount(batchItemResult.getReadCount() - batchItemResult.getFilterCount());
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                a.error((Object)exception);
                                for (BatchItemResult batchItemResult : map2.values()) {
                                    batchItemResult.setWriteCount(0);
                                }
                                if (batchDataResolver.getDialect().supportTransaction()) {
                                    RecordTranService.this.rollbackConnection(connection);
                                }
                                list2.add(exception);
                                if (batch.getSkipLimit() > 0) {
                                    if (batch.getSkipLimit() >= list2.size()) continue;
                                    throw exception;
                                }
                                throw exception;
                            }
                            finally {
                                RecordTranService.this.a(map);
                                RecordTranService.this.closeConnection(connection);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        RecordTranService.this.a(batch, batchResult, hashMap);
                    }
                    countDownLatch.countDown();
                }
            });
            threadArray[i].start();
        }
        try {
            countDownLatch.await();
            this.a(batch, batchResult, list);
            this.a(batchResult, concurrentHashMap);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            batchResult.setStatus(BatchStatus.failed);
            batchResult.setException(interruptedException);
        }
    }

    @Override
    protected Map<String, Object> a(Connection connection, BatchDataResolver batchDataResolver) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (BatchDataResolverItem batchDataResolverItem : batchDataResolver.getItems()) {
            PreparedStatement preparedStatement = connection.prepareStatement(batchDataResolverItem.getUpdateSql());
            hashMap.put(batchDataResolverItem.getName(), preparedStatement);
        }
        return hashMap;
    }
}

