/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.batch.utils;

import com.bstek.urule.console.database.model.batch.DataParam;
import com.bstek.urule.console.database.util.ParsedSql;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StmtUtils {
    public static final Log logger = LogFactory.getLog(StmtUtils.class);

    private static DataParam a(List<DataParam> list, String string) {
        for (DataParam dataParam : list) {
            if (!string.equals(dataParam.getName())) continue;
            return dataParam;
        }
        return null;
    }

    public static void setStmtQueryParameters(ParsedSql parsedSql, List<DataParam> list, PreparedStatement preparedStatement) throws Exception {
        for (int i = 0; i < parsedSql.getParameterNames().size(); ++i) {
            String string = parsedSql.getParameterNames().get(i);
            int n = i + 1;
            DataParam dataParam = StmtUtils.a(list, string);
            if (dataParam == null) {
                preparedStatement.setObject(n, null);
                continue;
            }
            Object object = dataParam.getValue();
            if (object instanceof String) {
                preparedStatement.setString(n, (String)object);
                continue;
            }
            if (object instanceof Boolean) {
                preparedStatement.setBoolean(n, (Boolean)object);
                continue;
            }
            if (object instanceof Integer) {
                preparedStatement.setInt(n, (Integer)object);
                continue;
            }
            if (object instanceof Long) {
                preparedStatement.setLong(n, (Long)object);
                continue;
            }
            if (object instanceof Double) {
                preparedStatement.setDouble(n, (Double)object);
                continue;
            }
            if (object instanceof Float) {
                preparedStatement.setFloat(n, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
                continue;
            }
            if (object instanceof Array) {
                preparedStatement.setArray(n, (Array)object);
                continue;
            }
            if (object instanceof Date) {
                preparedStatement.setTimestamp(n, new Timestamp(((Date)object).getTime()));
                continue;
            }
            preparedStatement.setObject(n, object);
        }
    }
}

