/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.cache.packet;

import com.bstek.urule.Configure;
import com.bstek.urule.Utils;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.cache.packet.PacketData;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryPacketCache {
    private Map<Long, PacketData> a = new ConcurrentHashMap<Long, PacketData>();
    private Map<String, PacketData> b = new ConcurrentHashMap<String, PacketData>();
    private Map<Long, byte[]> c = new ConcurrentHashMap<Long, byte[]>();

    public PacketData getPacket(long l) {
        return this.a.get(l);
    }

    public PacketData getPacket(String string) {
        return this.b.get(string);
    }

    public byte[] getKnowledgeWrapper(long l) {
        return this.c.get(l);
    }

    public void putPacket(long l, PacketData packetData) {
        this.a.put(l, packetData);
        byte[] byArray = this.a(packetData.getKnowledgePackageWrapper());
        this.c.put(l, byArray);
    }

    private byte[] a(KnowledgePackageWrapper knowledgePackageWrapper) {
        JsonMapper.Builder builder = JsonMapper.builder();
        builder.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        ObjectMapper objectMapper = builder.build();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(Configure.getDateFormat()));
        try {
            String string = objectMapper.writeValueAsString((Object)knowledgePackageWrapper);
            return Utils.compress((String)string);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonProcessingException.printStackTrace();
            throw new InfoException("\u5c1d\u8bd5\u5c06\u77e5\u8bc6\u5305\u5e8f\u5217\u5316\u5e76\u7f13\u5b58\u51fa\u9519:" + jsonProcessingException.getMessage());
        }
    }

    public void clear() {
        this.a.clear();
        this.b.clear();
        this.c.clear();
    }

    public void remove(long l) {
        this.a.remove(l);
        this.c.remove(l);
    }

    public void remove(String string) {
        this.b.remove(string);
    }

    public Map<Long, PacketData> getPacketIdMap() {
        HashMap<Long, PacketData> hashMap = new HashMap<Long, PacketData>();
        hashMap.putAll(this.a);
        return hashMap;
    }

    public Map<String, PacketData> getPacketCodeMap() {
        HashMap<String, PacketData> hashMap = new HashMap<String, PacketData>();
        hashMap.putAll(this.b);
        return hashMap;
    }

    public void putPacket(String string, PacketData packetData) {
        this.b.put(packetData.getPacket().getCode(), packetData);
    }
}

