/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.cache.packet;

import com.bstek.urule.Utils;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.cache.packet.ClientPacketCacheAdapter;
import com.bstek.urule.console.cache.packet.ClusterPacketCacheAdapter;
import com.bstek.urule.console.cache.packet.DefaultClientPacketCacheAdapter;
import com.bstek.urule.console.cache.packet.DefaultClusterPacketCacheAdapter;
import com.bstek.urule.console.cache.packet.MemoryPacketCache;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketConfig;
import com.bstek.urule.console.cache.packet.PacketData;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.PacketQuery;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.PacketPackage;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.DeserializeException;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class PacketCacheImpl
implements PacketCache {
    private ClusterPacketCacheAdapter a = null;
    private ClientPacketCacheAdapter b = null;
    private MemoryPacketCache c = new MemoryPacketCache();

    protected PacketCacheImpl() {
        this.b();
        try {
            this.a = (ClusterPacketCacheAdapter)Utils.getApplicationContext().getBean("urule.clusterPacketCacheAdapter");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            this.a = new DefaultClusterPacketCacheAdapter();
        }
        try {
            this.b = (ClientPacketCacheAdapter)Utils.getApplicationContext().getBean("urule.clientPacketCacheAdapter");
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            this.b = new DefaultClientPacketCacheAdapter();
        }
        this.a();
    }

    private void a() {
        Map<Long, PacketData> map = this.c.getPacketIdMap();
        for (Long l : map.keySet()) {
            PacketData packetData = map.get(l);
            this.a.putPacket(l, packetData);
            String string = packetData.getPacket().getCode();
            if (!StringUtils.isNotBlank(string)) continue;
            this.a.putPacket(string, packetData);
        }
    }

    public ClientPacketCacheAdapter getClientPacketCacheAdapter() {
        return this.b;
    }

    private void b() {
        List<PacketDeploy> list = PacketDeployManager.ins.newQuery().enable(true).listWithContent();
        for (PacketDeploy packetDeploy : list) {
            Packet packet = PacketManager.ins.load(packetDeploy.getPacketId());
            if (packet == null || !packet.isEnable()) continue;
            try {
                this.a(packetDeploy);
            }
            catch (DeserializeException deserializeException) {
                System.out.println("Packet deserialize error, packetId:" + packetDeploy.getPacketId() + ", deployId:" + packetDeploy.getId());
            }
        }
        this.cacheUploadPacketPackage(null);
    }

    public void doRecacheAllPackets() {
        this.c.clear();
        this.b();
    }

    public List<Map<String, Object>> recacheAllPackets(String string) {
        this.doRecacheAllPackets();
        IDGenerator.getInstance().clean();
        List<Map<String, Object>> list = this.a.recacheAllPackets(string);
        this.a();
        return list;
    }

    @Override
    public PacketData getPacket(String string) {
        return this.c.getPacket(string);
    }

    @Override
    public PacketData getPacket(long l) {
        return this.c.getPacket(l);
    }

    public void removePacket(long l) {
        this.doRemovePacket(l);
        this.a.remove(l);
    }

    public void doRemovePacket(long l) {
        this.c.remove(l);
    }

    public void removePacket(String string) {
        this.doRemovePacket(string);
        this.a.remove(string);
    }

    public void doRemovePacket(String string) {
        this.c.remove(string);
    }

    @Override
    public void refreshPacketConfig(long l) {
        PacketData packetData = this.getPacket(l);
        if (packetData == null) {
            return;
        }
        Packet packet = PacketManager.ins.load(l);
        PacketData packetData2 = new PacketData(packet, packetData.getKnowledgePackageWrapper());
        this.c.putPacket(l, packetData2);
        String string = packet.getCode();
        if (StringUtils.isNotBlank(string)) {
            this.c.putPacket(string, packetData2);
        }
    }

    @Override
    public List<Map<String, Object>> refreshPacket(long l) {
        String string = null;
        if (RequestHolder.getRequest() != null) {
            string = RequestHolder.getRequest().getParameter("groupId");
        }
        this.doReloadPacket(l);
        return this.a.refreshPacket(string, l);
    }

    public Packet doReloadPacket(long l) {
        Packet packet = PacketManager.ins.load(l);
        if (packet == null) {
            throw new RuleException("packet package:" + l + " not exist!");
        }
        if (!packet.isEnable()) {
            this.c.remove(l);
            String string = packet.getCode();
            if (StringUtils.isNotBlank(string)) {
                this.c.remove(string);
            }
            return packet;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<PacketDeploy> list = PacketDeployManager.ins.newQuery().packetId(l).enable(true).listWithContent();
        if (list.size() > 0) {
            PacketDeploy packetDeploy = list.get(0);
            this.a(packetDeploy);
            System.out.println("[" + simpleDateFormat.format(new Date()) + "] Successfully reload file packet package:" + l);
        } else {
            this.cacheUploadPacketPackage(l);
            System.out.println("[" + simpleDateFormat.format(new Date()) + "] Successfully reload upload packet package:" + l);
        }
        return packet;
    }

    @Override
    public List<Map<String, Object>> removeProject(long l, String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        List<PacketConfig> list = this.doRemoveProjectPackets(l);
        if (list.size() == 0) {
            return arrayList;
        }
        return this.a.removeProject(string, l, list);
    }

    public List<PacketConfig> doRemoveProjectPackets(long l) {
        ArrayList<PacketConfig> arrayList = new ArrayList<PacketConfig>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Map<String, PacketData> map = this.c.getPacketCodeMap();
        for (String object : map.keySet()) {
            PacketData packetData = map.get(object);
            if (packetData.getPacket().getProjectId() != l) continue;
            arrayList2.add(object);
            arrayList.add(packetData.getPacket());
        }
        for (PacketConfig packetConfig : arrayList) {
            this.c.remove(packetConfig.getId());
        }
        for (String string : arrayList2) {
            this.c.remove(string);
        }
        return arrayList;
    }

    @Override
    public void cacheUploadPacketPackage(Long l) {
        PacketQuery packetQuery = PacketManager.ins.newQuery();
        if (l != null) {
            packetQuery.id(l);
        }
        List<Packet> list = packetQuery.enable(true).typeLike("upload").list();
        for (Packet packet : list) {
            String string;
            PacketPackage packetPackage = PacketPackageManager.ins.loadByPacketId(packet.getId());
            if (packetPackage == null || StringUtils.isBlank(string = PacketPackageManager.ins.loadContent(packetPackage.getId()))) continue;
            boolean bl = true;
            KnowledgePackageWrapper knowledgePackageWrapper = null;
            if (l == null) {
                try {
                    knowledgePackageWrapper = Utils.stringToKnowledgePackageWrapper((String)string);
                }
                catch (DeserializeException deserializeException) {
                    bl = false;
                    System.out.println("Packet deserialize error, packetId:" + packetPackage.getPacketId() + ", deployId:" + packetPackage.getId());
                }
            } else {
                knowledgePackageWrapper = Utils.stringToKnowledgePackageWrapper((String)string);
            }
            if (!bl || knowledgePackageWrapper == null) continue;
            KnowledgePackageImpl knowledgePackageImpl = (KnowledgePackageImpl)knowledgePackageWrapper.getKnowledgePackage();
            knowledgePackageImpl.setPackageInfo(String.valueOf(packet.getId()));
            knowledgePackageImpl.setMonitor(packet.isAuditEnable());
            knowledgePackageImpl.setTimestamp(packet.getUpdateDate().getTime());
            this.a(packet, knowledgePackageWrapper);
        }
    }

    @Override
    public List<Map<String, Object>> enableClientsPacket(String string, long l) {
        return this.b.enableClientsPacket(string, l);
    }

    @Override
    public List<Map<String, Object>> disableClientsPacket(String string, long l) {
        return this.b.disableClientsPacket(string, l);
    }

    private void a(PacketDeploy packetDeploy) {
        KnowledgePackageWrapper knowledgePackageWrapper = Utils.stringToKnowledgePackageWrapper((String)packetDeploy.getContent());
        KnowledgePackageImpl knowledgePackageImpl = (KnowledgePackageImpl)knowledgePackageWrapper.getKnowledgePackage();
        Packet packet = PacketManager.ins.load(packetDeploy.getPacketId());
        knowledgePackageImpl.setVersion(packetDeploy.getVersion());
        knowledgePackageImpl.setPackageInfo(String.valueOf(packet.getId()));
        knowledgePackageImpl.setMonitor(packet.isAuditEnable());
        knowledgePackageImpl.setTimestamp(packet.getUpdateDate().getTime());
        this.a(packet, knowledgePackageWrapper);
    }

    private void a(Packet packet, KnowledgePackageWrapper knowledgePackageWrapper) {
        PacketData packetData = new PacketData(packet, knowledgePackageWrapper);
        this.c.putPacket(packet.getId(), packetData);
        String string = packet.getCode();
        if (StringUtils.isNotBlank(string)) {
            this.c.putPacket(string, packetData);
        }
    }

    @Override
    public byte[] getKnowledgeContent(long l) {
        return this.c.getKnowledgeWrapper(l);
    }
}

