/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.config;

import com.bstek.urule.console.config.ApplicationConfig;
import com.bstek.urule.console.config.ConfigManager;
import com.bstek.urule.console.config.ConfigType;
import com.bstek.urule.console.config.manager.ConnectionConfigManager;
import com.bstek.urule.console.config.manager.DBConfigManager;
import com.bstek.urule.console.config.manager.JNDIConfigManager;
import com.bstek.urule.console.config.manager.JdbcConfigManager;

public class ConfigureManagerFactory {
    public static ConfigManager initConfigManager(ApplicationConfig applicationConfig) {
        DBConfigManager dBConfigManager = null;
        String string = applicationConfig.getConfigType();
        ConfigType configType = ConfigType.valueOf(string);
        if (configType == ConfigType.embed || configType == ConfigType.jdbc) {
            dBConfigManager = new JdbcConfigManager(applicationConfig);
        } else if (configType == ConfigType.connection) {
            dBConfigManager = new ConnectionConfigManager(applicationConfig);
        } else if (configType == ConfigType.jndi) {
            dBConfigManager = new JNDIConfigManager(applicationConfig);
        }
        if (dBConfigManager == null) {
            dBConfigManager = new JdbcConfigManager(applicationConfig);
        }
        return dBConfigManager;
    }
}

