/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.config.dialect;

import com.bstek.urule.console.config.dialect.DB2Dialect;
import com.bstek.urule.console.config.dialect.Dialect;
import com.bstek.urule.console.config.dialect.DmDialect;
import com.bstek.urule.console.config.dialect.H2Dialect;
import com.bstek.urule.console.config.dialect.HSQLDialect;
import com.bstek.urule.console.config.dialect.HiveDialect;
import com.bstek.urule.console.config.dialect.InformixDialect;
import com.bstek.urule.console.config.dialect.MySQLDialect;
import com.bstek.urule.console.config.dialect.Oracle10gDialect;
import com.bstek.urule.console.config.dialect.PostgreSQLDialect;
import com.bstek.urule.console.config.dialect.PrestoDialect;
import com.bstek.urule.console.config.dialect.SQLLiteDialect;
import com.bstek.urule.console.config.dialect.SQLServerDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DialectResolver {
    private static final Log a = LogFactory.getLog(DialectResolver.class);

    public static final Dialect resolveDialect(Connection connection) {
        try {
            return DialectResolver.a(connection.getMetaData());
        }
        catch (SQLException sQLException) {
            a.warn((Object)sQLException.getMessage());
            return null;
        }
        catch (Throwable throwable) {
            a.warn((Object)("Error executing resolver [DialectResolver] : " + throwable.getMessage()));
            return null;
        }
    }

    protected static Dialect a(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getDatabaseProductName();
        if ("HSQL Database Engine".equals(string)) {
            return new HSQLDialect();
        }
        if ("H2".equals(string)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(string)) {
            return new MySQLDialect();
        }
        if ("DM DBMS".equals(string)) {
            return new DmDialect();
        }
        if ("PostgreSQL".equals(string) || "KingbaseES".equals(string)) {
            return new PostgreSQLDialect();
        }
        if (string.startsWith("Microsoft SQL Server")) {
            return new SQLServerDialect();
        }
        if ("Informix Dynamic Server".equals(string)) {
            return new InformixDialect();
        }
        if (string.startsWith("DB2/")) {
            return new DB2Dialect();
        }
        if ("Oracle".equals(string)) {
            return new Oracle10gDialect();
        }
        if ("SQLite".equals(string)) {
            return new SQLLiteDialect();
        }
        if ("Apache Hive".equals(string)) {
            return new HiveDialect();
        }
        if ("Presto".equals(string)) {
            return new PrestoDialect();
        }
        return null;
    }
}

