/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.config.manager;

import com.bstek.urule.console.config.ApplicationConfig;
import com.bstek.urule.console.config.Configuration;
import com.bstek.urule.console.config.exception.ConfigLoadException;
import com.bstek.urule.console.config.exception.SetupException;
import com.bstek.urule.console.config.manager.AbstractConfigManager;
import com.bstek.urule.console.config.script.DataSourceInitializer;
import com.bstek.urule.console.config.setup.SetupInfo;
import com.bstek.urule.console.database.util.ConfigurationUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DBConfigManager
extends AbstractConfigManager {
    private static final Log b = LogFactory.getLog(DBConfigManager.class);

    public DBConfigManager(ApplicationConfig applicationConfig) {
        super(applicationConfig);
    }

    @Override
    public void load() throws ConfigLoadException {
        try {
            this.d();
            this.e();
        }
        catch (Exception exception) {
            b.error((Object)exception);
            throw new ConfigLoadException(exception);
        }
    }

    protected abstract void initConfig(SetupInfo var1);

    @Override
    public void init(SetupInfo setupInfo) throws SetupException {
        try {
            this.initConfig(setupInfo);
            this.d();
            if (setupInfo.isInitializationDb()) {
                this.a(setupInfo);
            }
        }
        catch (SetupException setupException) {
            throw setupException;
        }
        catch (Exception exception) {
            b.error((Object)exception);
            throw new SetupException(exception);
        }
    }

    protected abstract void d() throws Exception;

    private void a(SetupInfo setupInfo) throws Exception {
        Connection connection = null;
        try {
            b.info((Object)"\u89c4\u5219\u6570\u636e\u5e93\u521d\u59cb\u5316...");
            connection = this.getConnection();
            connection.setAutoCommit(false);
            String string = this.getPlatform();
            if ("dm".equals(string)) {
                string = "oracle";
            } else if ("kingbase".equals(string)) {
                string = "postgresql";
            }
            DataSourceInitializer.executeSchema(connection, string);
            b.info((Object)"\u89c4\u5219\u6570\u636e\u5e93\u8868\u7ed3\u6784\u521d\u59cb\u5316\u6210\u529f...");
            DataSourceInitializer.executeInitData(connection, string);
            b.info((Object)"\u89c4\u5219\u6570\u636e\u5e93\u914d\u7f6e\u6570\u636e\u521d\u59cb\u5316\u6210\u529f...");
            connection.commit();
            b.info((Object)"\u89c4\u5219\u6570\u636e\u5e93\u521d\u59cb\u5316\u5b8c\u6210.");
        }
        catch (Exception exception) {
            try {
                b.error((Object)("\u89c4\u5219\u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25:" + exception.getMessage()));
                if (connection != null) {
                    connection.rollback();
                }
                throw exception;
            }
            catch (Throwable throwable) {
                DBConfigManager.closeConnection(connection);
                throw throwable;
            }
        }
        DBConfigManager.closeConnection(connection);
    }

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                b.debug((Object)"Could not close JDBC Connection", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                b.debug((Object)"Unexpected exception on closing JDBC Connection", throwable);
            }
        }
    }

    protected void e() throws Exception {
        List<Configuration> list = ConfigurationUtils.getConfigurations(this.getConnection());
        for (Configuration configuration : list) {
            this.a.put(configuration.getKey(), configuration.getValue());
        }
    }

    public String getPlatform() {
        return this.getProperty("urule.store.database.platform");
    }

    public abstract Connection getConnection() throws Exception;
}

