/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.authority;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.authority.AuthorityManager;
import com.bstek.urule.console.database.model.Authority;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class AuthorityManagerImpl
implements AuthorityManager {
    @Override
    public List<Authority> getAuthoritysByRole(String string, long l) {
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select ID_, ROLE_ID_, RESOURCE_CODE_, AUTH_, ROLE_TYPE_, RESOURCE_TYPE_ from URULE_AUTHORITY where ROLE_ID_=? and ROLE_TYPE_=?";
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new Authority();
                ((Authority)object).setId(resultSet.getLong(1));
                ((Authority)object).setRoleId(resultSet.getLong(2));
                ((Authority)object).setResourceCode(resultSet.getString(3));
                ((Authority)object).setAuth(resultSet.getInt(4));
                ((Authority)object).setRoleType(resultSet.getString(5));
                ((Authority)object).setResourceType(resultSet.getString(6));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(Connection connection, Authority authority) {
        String string = "insert into URULE_AUTHORITY (ID_, ROLE_ID_, RESOURCE_CODE_, AUTH_, ROLE_TYPE_, RESOURCE_TYPE_) values (?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            long l = IDGenerator.getInstance().nextId(IDType.AUTHORITY);
            authority.setId(l);
            preparedStatement.setLong(1, authority.getId());
            preparedStatement.setLong(2, authority.getRoleId());
            preparedStatement.setString(3, authority.getResourceCode());
            preparedStatement.setInt(4, authority.getAuth());
            preparedStatement.setString(5, authority.getRoleType());
            preparedStatement.setString(6, authority.getResourceType());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void remove(Connection connection, long l) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_AUTHORITY where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void removeByRole(String string, long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_AUTHORITY where ROLE_TYPE_=? and ROLE_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public Authority get(String string, long l, String string2) {
        Authority authority = null;
        Connection connection = JdbcUtils.getConnection();
        String string3 = "select ID_, ROLE_ID_, RESOURCE_CODE_, AUTH_, ROLE_TYPE_, RESOURCE_TYPE_ from URULE_AUTHORITY where ROLE_ID_=? and ROLE_TYPE_=? and RESOURCE_CODE_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            ArrayList<Authority> arrayList = new ArrayList<Authority>();
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                authority = new Authority();
                authority.setId(resultSet.getLong(1));
                authority.setRoleId(resultSet.getLong(2));
                authority.setResourceCode(resultSet.getString(3));
                authority.setAuth(resultSet.getInt(4));
                authority.setRoleType(resultSet.getString(5));
                authority.setResourceType(resultSet.getString(6));
                arrayList.add(authority);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            Authority authority2 = authority;
            return authority2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<Authority> getAuthoritysByCode(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        String string3 = "select ID_, ROLE_ID_, RESOURCE_CODE_, AUTH_, ROLE_TYPE_, RESOURCE_TYPE_ from URULE_AUTHORITY where RESOURCE_CODE_=? and ROLE_TYPE_=?";
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new Authority();
                ((Authority)object).setId(resultSet.getLong(1));
                ((Authority)object).setRoleId(resultSet.getLong(2));
                ((Authority)object).setResourceCode(resultSet.getString(3));
                ((Authority)object).setAuth(resultSet.getInt(4));
                ((Authority)object).setRoleType(resultSet.getString(5));
                ((Authority)object).setResourceType(resultSet.getString(6));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Connection connection, String string, long l, String string2, String string3) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_AUTHORITY where ROLE_TYPE_=? and ROLE_ID_=? and RESOURCE_CODE_=?  and RESOURCE_TYPE_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string3);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }
}

