/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.authority;

import com.bstek.urule.console.database.manager.authority.AuthorityManager;
import com.bstek.urule.console.database.manager.authority.AuthorityService;
import com.bstek.urule.console.database.model.Authority;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.security.AuthenticationManager;
import com.bstek.urule.console.security.entity.Module;
import com.bstek.urule.console.security.entity.Permission;
import com.bstek.urule.console.security.provider.PermissionProvider;
import com.bstek.urule.console.type.GroupRoleEnum;
import com.bstek.urule.console.type.ProjectRoleEnum;
import com.bstek.urule.console.type.RoleCategory;
import java.sql.Connection;
import java.util.List;

public class AuthorityServiceImpl
implements AuthorityService {
    @Override
    public List<Authority> getAuthoritysByRole(String string, long l) {
        return AuthorityManager.ins.getAuthoritysByRole(string, l);
    }

    @Override
    public void add(Authority authority) {
        Connection connection = JdbcUtils.getConnection();
        try {
            AuthorityManager.ins.add(connection, authority);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            AuthorityManager.ins.remove(connection, l);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByRole(String string, long l) {
        AuthorityManager.ins.removeByRole(string, l);
    }

    @Override
    public Authority get(String string, long l, String string2) {
        return AuthorityManager.ins.get(string, l, string2);
    }

    @Override
    public List<Module> getGroupModels(Role role) {
        List<Module> list = PermissionProvider.getGroupModules();
        for (Module module : list) {
            if (role.getName().equals(GroupRoleEnum.Owner.name())) {
                module.setChecked(true);
                module.setDisabled(true);
            }
            for (Permission permission : module.getItems()) {
                if (role.getName().equals(GroupRoleEnum.Owner.name())) {
                    permission.setChecked(true);
                    permission.setDisabled(true);
                    continue;
                }
                permission.setChecked(AuthenticationManager.decide(role, RoleCategory.group, module.getCode(), permission.getCode()));
            }
        }
        return list;
    }

    @Override
    public List<Module> getProjectModels(Role role) {
        List<Module> list = PermissionProvider.getProjectModules();
        for (Module module : list) {
            if (role.getName().equals(ProjectRoleEnum.Manager.name())) {
                module.setChecked(true);
                module.setDisabled(true);
            }
            for (Permission permission : module.getItems()) {
                if (role.getName().equals(ProjectRoleEnum.Manager.name())) {
                    permission.setChecked(true);
                    permission.setDisabled(true);
                    continue;
                }
                permission.setChecked(AuthenticationManager.decide(role, RoleCategory.project, module.getCode(), permission.getCode()));
            }
        }
        return list;
    }

    private void a(long l, Module module, Permission permission, boolean bl) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Authority authority = new Authority();
            authority.setAuth(1);
            authority.setRoleId(l);
            authority.setRoleType(module.getType().toString());
            String string = module.getCode() + "_" + permission.getCode();
            authority.setResourceCode(string);
            authority.setResourceType(permission.getType().toString());
            if (permission.isChecked()) {
                AuthorityManager.ins.add(connection, authority);
            } else if (bl) {
                this.remove(connection, module.getType().toString(), l, string, permission.getType().toString());
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public void remove(Connection connection, String string, long l, String string2, String string3) {
        AuthorityManager.ins.remove(connection, string, l, string2, string3);
    }

    @Override
    public void storePermissions(long l, List<Module> list) {
        for (Module module : list) {
            for (Permission permission : module.getItems()) {
                this.a(l, module, permission, true);
            }
        }
    }

    @Override
    public void initPermissions(long l, List<Module> list) {
        for (Module module : list) {
            for (Permission permission : module.getItems()) {
                this.a(l, module, permission, false);
            }
        }
    }
}

