/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.batch.provider;

import com.bstek.urule.console.database.manager.batch.provider.ProviderFieldManager;
import com.bstek.urule.console.database.manager.batch.provider.ProviderFieldQuery;
import com.bstek.urule.console.database.manager.batch.provider.ProviderFieldQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchDataProviderField;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.List;

public class ProviderFieldManagerImpl
implements ProviderFieldManager {
    @Override
    public BatchDataProviderField get(Long l) {
        List<BatchDataProviderField> list = this.createQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(BatchDataProviderField batchDataProviderField) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_BATCH_PROVIDER_FIELD (SRC_PROPERTY_, DATA_TYPE_, DEST_PROPERTY_, CLAZZ_PATH_, DATA_PROVIDER_ID_, CREATE_USER_, CREATE_DATE_, ID_, PROJECT_ID_, BATCH_ID_, PROVIDER_ID_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, batchDataProviderField.getSrcProperty());
            preparedStatement.setString(2, batchDataProviderField.getDataType());
            preparedStatement.setString(3, batchDataProviderField.getDestProperty());
            preparedStatement.setString(4, batchDataProviderField.getClassPath());
            if (batchDataProviderField.getDataProviderId() == null) {
                preparedStatement.setObject(5, null);
            } else {
                preparedStatement.setLong(5, batchDataProviderField.getDataProviderId());
            }
            preparedStatement.setString(6, batchDataProviderField.getCreateUser());
            preparedStatement.setTimestamp(7, new Timestamp(batchDataProviderField.getCreateDate().getTime()));
            preparedStatement.setLong(8, batchDataProviderField.getId());
            preparedStatement.setLong(9, batchDataProviderField.getProjectId());
            preparedStatement.setLong(10, batchDataProviderField.getBatchId());
            preparedStatement.setLong(11, batchDataProviderField.getProviderId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(BatchDataProviderField batchDataProviderField) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_BATCH_PROVIDER_FIELD set SRC_PROPERTY_=?, DATA_TYPE_=?, DEST_PROPERTY_=?, CLAZZ_PATH_=?, DATA_PROVIDER_ID_=?, UPDATE_DATE_=? , UPDATE_USER_=? where ID_=?");
            preparedStatement.setString(1, batchDataProviderField.getSrcProperty());
            preparedStatement.setString(2, batchDataProviderField.getDataType());
            preparedStatement.setString(3, batchDataProviderField.getDestProperty());
            preparedStatement.setString(4, batchDataProviderField.getClassPath());
            if (batchDataProviderField.getDataProviderId() == null) {
                preparedStatement.setObject(5, null);
            } else {
                preparedStatement.setLong(5, batchDataProviderField.getDataProviderId());
            }
            preparedStatement.setTimestamp(6, new Timestamp(batchDataProviderField.getUpdateDate().getTime()));
            preparedStatement.setString(7, batchDataProviderField.getUpdateUser());
            preparedStatement.setLong(8, batchDataProviderField.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_PROVIDER_FIELD where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByProviderId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_PROVIDER_FIELD where PROVIDER_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByBatchId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_PROVIDER_FIELD where BATCH_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public ProviderFieldQuery createQuery() {
        return new ProviderFieldQueryImpl();
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_PROVIDER_FIELD where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_PROVIDER_FIELD where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

