/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.batch.provider;

import com.bstek.urule.console.database.manager.batch.provider.ProviderManager;
import com.bstek.urule.console.database.manager.batch.provider.ProviderQuery;
import com.bstek.urule.console.database.manager.batch.provider.ProviderQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchDataProvider;
import com.bstek.urule.console.database.model.batch.BatchDataProviderField;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.List;

public class ProviderManagerImpl
implements ProviderManager {
    @Override
    public BatchDataProvider get(Long l) {
        List<BatchDataProvider> list = this.createQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(BatchDataProvider batchDataProvider) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_BATCH_DATA_PROVIDER (NAME_, DATASOURCE_ID_, INPUT_DATA_, PACKET_VAR_NAME_, SUPPORT_PAGING_, PAGE_SIZE_, PAGE_SQL_, ORDER_FIELD_, ORDER_FIELD_PARAM_NAME_, PAGE_LIMIT_TYPE_, COUNT_SQL_, DESC_, CREATE_USER_, CREATE_DATE_, ID_, PROJECT_ID_, BATCH_ID_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, batchDataProvider.getName());
            preparedStatement.setLong(2, batchDataProvider.getDatasourceId());
            preparedStatement.setString(3, batchDataProvider.getInputData());
            preparedStatement.setString(4, batchDataProvider.getPacketVarName());
            preparedStatement.setBoolean(5, batchDataProvider.isSupportsPaging());
            preparedStatement.setInt(6, batchDataProvider.getPageSize());
            preparedStatement.setString(7, batchDataProvider.getPageSql());
            preparedStatement.setString(8, batchDataProvider.getOrderField());
            preparedStatement.setString(9, batchDataProvider.getOrderFieldParamName());
            preparedStatement.setString(10, batchDataProvider.getPageLimitType());
            preparedStatement.setString(11, batchDataProvider.getCountSql());
            preparedStatement.setString(12, batchDataProvider.getDesc());
            preparedStatement.setString(13, batchDataProvider.getCreateUser());
            preparedStatement.setTimestamp(14, new Timestamp(batchDataProvider.getCreateDate().getTime()));
            preparedStatement.setLong(15, batchDataProvider.getId());
            preparedStatement.setLong(16, batchDataProvider.getProjectId());
            preparedStatement.setLong(17, batchDataProvider.getBatchId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(BatchDataProvider batchDataProvider) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_BATCH_DATA_PROVIDER set NAME_=?, DATASOURCE_ID_=?, INPUT_DATA_=?, PACKET_VAR_NAME_=?, SUPPORT_PAGING_=?, PAGE_SIZE_=?, PAGE_SQL_=?, ORDER_FIELD_=?, ORDER_FIELD_PARAM_NAME_=?, PAGE_LIMIT_TYPE_=?, COUNT_SQL_=?, DESC_=?, UPDATE_DATE_=? , UPDATE_USER_=? where ID_=?");
            preparedStatement.setString(1, batchDataProvider.getName());
            preparedStatement.setLong(2, batchDataProvider.getDatasourceId());
            preparedStatement.setString(3, batchDataProvider.getInputData());
            preparedStatement.setString(4, batchDataProvider.getPacketVarName());
            preparedStatement.setBoolean(5, batchDataProvider.isSupportsPaging());
            preparedStatement.setInt(6, batchDataProvider.getPageSize());
            preparedStatement.setString(7, batchDataProvider.getPageSql());
            preparedStatement.setString(8, batchDataProvider.getOrderField());
            preparedStatement.setString(9, batchDataProvider.getOrderFieldParamName());
            preparedStatement.setString(10, batchDataProvider.getPageLimitType());
            preparedStatement.setString(11, batchDataProvider.getCountSql());
            preparedStatement.setString(12, batchDataProvider.getDesc());
            preparedStatement.setTimestamp(13, new Timestamp(batchDataProvider.getUpdateDate().getTime()));
            preparedStatement.setString(14, batchDataProvider.getUpdateUser());
            preparedStatement.setLong(15, batchDataProvider.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_PROVIDER where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByBatchId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_PROVIDER where BATCH_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<BatchDataProviderField> getMappings(Long l) {
        return null;
    }

    @Override
    public ProviderQuery createQuery() {
        return new ProviderQueryImpl();
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_PROVIDER where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_PROVIDER where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

