/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.batch.resolver;

import com.bstek.urule.console.database.manager.batch.resolver.ResolverFieldManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverFieldQuery;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverFieldQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItemField;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.List;

public class ResolverFieldManagerImpl
implements ResolverFieldManager {
    @Override
    public BatchDataResolverItemField get(Long l) {
        List<BatchDataResolverItemField> list = this.createQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(BatchDataResolverItemField batchDataResolverItemField) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_BATCH_RESOLVER_FIELD (SRC_PROPERTY_, DATA_TYPE_, DEST_PROPERTY_, CREATE_USER_, CREATE_DATE_, ID_, PROJECT_ID_, BATCH_ID_, RESOLVER_ID_, ITEM_ID_, KEY_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, batchDataResolverItemField.getSrcProperty());
            preparedStatement.setString(2, batchDataResolverItemField.getDataType());
            preparedStatement.setString(3, batchDataResolverItemField.getDestProperty());
            preparedStatement.setString(4, batchDataResolverItemField.getCreateUser());
            preparedStatement.setTimestamp(5, new Timestamp(batchDataResolverItemField.getCreateDate().getTime()));
            preparedStatement.setLong(6, batchDataResolverItemField.getId());
            preparedStatement.setLong(7, batchDataResolverItemField.getProjectId());
            preparedStatement.setLong(8, batchDataResolverItemField.getBatchId());
            preparedStatement.setLong(9, batchDataResolverItemField.getResolverId());
            preparedStatement.setLong(10, batchDataResolverItemField.getResolverItemId());
            preparedStatement.setBoolean(11, batchDataResolverItemField.isKey());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(BatchDataResolverItemField batchDataResolverItemField) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_BATCH_RESOLVER_FIELD set SRC_PROPERTY_=?, DATA_TYPE_=?, DEST_PROPERTY_=?, UPDATE_DATE_=? , UPDATE_USER_=?, KEY_=? where ID_=?");
            preparedStatement.setString(1, batchDataResolverItemField.getSrcProperty());
            preparedStatement.setString(2, batchDataResolverItemField.getDataType());
            preparedStatement.setString(3, batchDataResolverItemField.getDestProperty());
            preparedStatement.setTimestamp(4, new Timestamp(batchDataResolverItemField.getUpdateDate().getTime()));
            preparedStatement.setString(5, batchDataResolverItemField.getUpdateUser());
            preparedStatement.setBoolean(6, batchDataResolverItemField.isKey());
            preparedStatement.setLong(7, batchDataResolverItemField.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_FIELD where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByItemId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_FIELD where ITEM_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByResolverId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_FIELD where RESOLVER_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByBatchId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_FIELD where BATCH_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public ResolverFieldQuery createQuery() {
        return new ResolverFieldQueryImpl();
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_FIELD where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_FIELD where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

