/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.batch.resolver;

import com.bstek.urule.console.database.manager.batch.resolver.ResolverItemManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverItemQuery;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverItemQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItemField;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.List;

public class ResolverItemManagerImpl
implements ResolverItemManager {
    @Override
    public BatchDataResolverItem get(Long l) {
        List<BatchDataResolverItem> list = this.createQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(BatchDataResolverItem batchDataResolverItem) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_BATCH_RESOLVER_ITEM (NAME_, UPDATE_MODE_, TABLE_NAME_, VALIDATOR_DATA_, PARTITION_NAME_, PARTITION_VALUE_, COMMIT_LIMIT_, DESC_, CREATE_USER_, CREATE_DATE_, ID_, BATCH_ID_, PROJECT_ID_, RESOLVER_ID_)  values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, batchDataResolverItem.getName());
            preparedStatement.setString(2, batchDataResolverItem.getUpdateMode().name());
            preparedStatement.setString(3, batchDataResolverItem.getTableName());
            preparedStatement.setString(4, batchDataResolverItem.getFilterData());
            preparedStatement.setString(5, batchDataResolverItem.getPartitionName());
            preparedStatement.setString(6, batchDataResolverItem.getPartitionValue());
            preparedStatement.setInt(7, batchDataResolverItem.getCommitLimit());
            preparedStatement.setString(8, batchDataResolverItem.getDesc());
            preparedStatement.setString(9, batchDataResolverItem.getCreateUser());
            preparedStatement.setTimestamp(10, new Timestamp(batchDataResolverItem.getCreateDate().getTime()));
            preparedStatement.setLong(11, batchDataResolverItem.getId());
            preparedStatement.setLong(12, batchDataResolverItem.getBatchId());
            preparedStatement.setLong(13, batchDataResolverItem.getProjectId());
            preparedStatement.setLong(14, batchDataResolverItem.getResolverId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(BatchDataResolverItem batchDataResolverItem) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_BATCH_RESOLVER_ITEM set NAME_=?, UPDATE_MODE_=?, TABLE_NAME_=?, VALIDATOR_DATA_=?, PARTITION_NAME_=?, PARTITION_VALUE_=?, COMMIT_LIMIT_=?, DESC_=?, UPDATE_DATE_=? , UPDATE_USER_=? where ID_=?");
            preparedStatement.setString(1, batchDataResolverItem.getName());
            preparedStatement.setString(2, batchDataResolverItem.getUpdateMode().name());
            preparedStatement.setString(3, batchDataResolverItem.getTableName());
            preparedStatement.setString(4, batchDataResolverItem.getFilterData());
            preparedStatement.setString(5, batchDataResolverItem.getPartitionName());
            preparedStatement.setString(6, batchDataResolverItem.getPartitionValue());
            preparedStatement.setInt(7, batchDataResolverItem.getCommitLimit());
            preparedStatement.setString(8, batchDataResolverItem.getDesc());
            preparedStatement.setTimestamp(9, new Timestamp(batchDataResolverItem.getUpdateDate().getTime()));
            preparedStatement.setString(10, batchDataResolverItem.getUpdateUser());
            preparedStatement.setLong(11, batchDataResolverItem.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_ITEM where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByResolverId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_ITEM where RESOLVER_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByBatchId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_ITEM where BATCH_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<BatchDataResolverItemField> getMappings(Long l) {
        return null;
    }

    @Override
    public ResolverItemQuery createQuery() {
        return new ResolverItemQueryImpl();
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_ITEM where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_RESOLVER_ITEM where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

