/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.batch.resolver;

import com.bstek.urule.console.database.manager.batch.resolver.ResolverManager;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverQuery;
import com.bstek.urule.console.database.manager.batch.resolver.ResolverQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.List;

public class ResolverManagerImpl
implements ResolverManager {
    @Override
    public BatchDataResolver get(Long l) {
        List<BatchDataResolver> list = this.createQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(BatchDataResolver batchDataResolver) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_BATCH_DATA_RESOLVER (NAME_, TRAN_SCOPE_, DESC_, CREATE_DATE_ , CREATE_USER_, ID_, BATCH_ID_, PROJECT_ID_, DATASOURCE_ID_) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, batchDataResolver.getName());
            preparedStatement.setString(2, batchDataResolver.getTranScope().name());
            preparedStatement.setString(3, batchDataResolver.getDesc());
            preparedStatement.setTimestamp(4, new Timestamp(batchDataResolver.getCreateDate().getTime()));
            preparedStatement.setString(5, batchDataResolver.getCreateUser());
            preparedStatement.setLong(6, batchDataResolver.getId());
            preparedStatement.setLong(7, batchDataResolver.getBatchId());
            preparedStatement.setLong(8, batchDataResolver.getProjectId());
            preparedStatement.setLong(9, batchDataResolver.getDatasourceId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(BatchDataResolver batchDataResolver) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_BATCH_DATA_RESOLVER set NAME_=?, TRAN_SCOPE_=?, DESC_=?, UPDATE_DATE_=? , UPDATE_USER_=?, DATASOURCE_ID_=? where ID_=?");
            preparedStatement.setString(1, batchDataResolver.getName());
            preparedStatement.setString(2, batchDataResolver.getTranScope().name());
            preparedStatement.setString(3, batchDataResolver.getDesc());
            preparedStatement.setTimestamp(4, new Timestamp(batchDataResolver.getUpdateDate().getTime()));
            preparedStatement.setString(5, batchDataResolver.getUpdateUser());
            preparedStatement.setLong(6, batchDataResolver.getDatasourceId());
            preparedStatement.setLong(7, batchDataResolver.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_RESOLVER where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByBatchId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_RESOLVER where BATCH_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<BatchDataResolverItem> getResolverItemss(Long l) {
        return null;
    }

    @Override
    public ResolverQuery createQuery() {
        return new ResolverQueryImpl();
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_RESOLVER where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_BATCH_DATA_RESOLVER where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

