/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.configuration;

import com.bstek.urule.console.config.Configuration;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.configuration.ConfigurationManager;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.database.util.NamedSQLUtils;
import com.bstek.urule.console.database.util.ParsedSql;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    @Override
    public void getConfigurations(Configuration configuration, Page<Configuration> page) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string = "select ID_, KEY_, VALUE_, LABEL_, TYPE_, CREATE_DATE_, UPDATE_DATE_ from URULE_PROPERTY";
            String string2 = "";
            if (StringUtils.isNotBlank(configuration.getKey())) {
                if (StringUtils.isNotBlank(string2)) {
                    string2 = string2 + " or ";
                }
                string2 = string2 + "KEY_ like :key ";
            }
            if (StringUtils.isNotBlank(configuration.getLabel())) {
                if (StringUtils.isNotBlank(string2)) {
                    string2 = string2 + " or ";
                }
                string2 = string2 + "LABEL_ like :label ";
            }
            if (StringUtils.isNotBlank(configuration.getType())) {
                if (StringUtils.isNotBlank(string2)) {
                    string2 = string2 + " or ";
                }
                string2 = string2 + "TYPE_ = :type ";
            }
            if (StringUtils.isNotBlank(string2)) {
                string2 = " where " + string2;
            }
            ParsedSql parsedSql = NamedSQLUtils.parseSql(JdbcUtils.getPageSql(string + string2, page.getStartRow(), page.getPageSize()));
            PreparedStatement preparedStatement = connection.prepareStatement(JdbcUtils.getOriginSql(parsedSql.getOriginalSql()));
            for (int i = 0; i < parsedSql.getParameterNames().size(); ++i) {
                object = parsedSql.getParameterNames().get(i);
                int n = i + 1;
                if ("key".equals(object)) {
                    preparedStatement.setString(n, "%" + configuration.getKey() + "%");
                }
                if ("label".equals(object)) {
                    preparedStatement.setString(n, "%" + configuration.getLabel() + "%");
                }
                if (!"type".equals(object)) continue;
                preparedStatement.setString(n, configuration.getType());
            }
            ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
            object = preparedStatement.executeQuery();
            while (object.next()) {
                Configuration configuration2 = new Configuration();
                configuration2.setId(object.getLong(1));
                configuration2.setKey(object.getString(2));
                configuration2.setValue(object.getString(3));
                configuration2.setLabel(object.getString(4));
                configuration2.setType(object.getString(5));
                configuration2.setCreateDate(object.getTimestamp(6));
                configuration2.setUpdateDate(object.getTimestamp(7));
                arrayList.add(configuration2);
            }
            JdbcUtils.closeResultSet((ResultSet)object);
            page.setData(arrayList);
            String string3 = JdbcUtils.getCountSql(string + string2);
            parsedSql = NamedSQLUtils.parseSql(string3);
            preparedStatement = connection.prepareStatement(JdbcUtils.getOriginSql(parsedSql.getOriginalSql()));
            for (int i = 0; i < parsedSql.getParameterNames().size(); ++i) {
                String string4 = parsedSql.getParameterNames().get(i);
                int n = i + 1;
                if ("key".equals(string4)) {
                    preparedStatement.setString(n, "%" + configuration.getKey() + "%");
                }
                if ("label".equals(string4)) {
                    preparedStatement.setString(n, "%" + configuration.getLabel() + "%");
                }
                if (!"type".equals(string4)) continue;
                preparedStatement.setString(n, configuration.getType());
            }
            object = preparedStatement.executeQuery();
            if (object.next()) {
                page.setTotalRows(object.getLong(1));
            }
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateConfiguration(Configuration configuration) {
        Connection connection = JdbcUtils.getConnection();
        try {
            configuration.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_PROPERTY set KEY_=?, LABEL_=?, TYPE_=?, VALUE_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, configuration.getKey());
            preparedStatement.setString(2, configuration.getLabel());
            preparedStatement.setString(3, configuration.getType());
            preparedStatement.setString(4, configuration.getValue());
            preparedStatement.setTimestamp(5, new Timestamp(configuration.getUpdateDate().getTime()));
            preparedStatement.setLong(6, configuration.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void insertConfiguration(Configuration configuration) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_PROPERTY (ID_, KEY_, LABEL_, TYPE_, VALUE_, CREATE_DATE_, UPDATE_DATE_) values(?,?,?,?,?,?,?)");
            long l = IDGenerator.getInstance().nextId(IDType.PROPERTY);
            configuration.setCreateDate(new Timestamp(System.currentTimeMillis()));
            configuration.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            configuration.setId(l);
            preparedStatement.setLong(1, configuration.getId());
            preparedStatement.setString(2, configuration.getKey());
            preparedStatement.setString(3, configuration.getLabel());
            preparedStatement.setString(4, configuration.getType());
            preparedStatement.setString(5, configuration.getValue());
            preparedStatement.setTimestamp(6, new Timestamp(configuration.getCreateDate().getTime()));
            preparedStatement.setTimestamp(7, new Timestamp(configuration.getUpdateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteConfiguration(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_PROPERTY where ID_=? and TYPE_!='system'");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public Configuration getConfiguration(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select ID_, KEY_, VALUE_, LABEL_, TYPE_, CREATE_DATE_, UPDATE_DATE_ from URULE_PROPERTY WHERE KEY_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Configuration configuration = new Configuration();
                configuration.setId(resultSet.getLong(1));
                configuration.setKey(resultSet.getString(2));
                configuration.setValue(resultSet.getString(3));
                configuration.setLabel(resultSet.getString(4));
                configuration.setType(resultSet.getString(5));
                configuration.setCreateDate(resultSet.getTimestamp(6));
                configuration.setUpdateDate(resultSet.getTimestamp(7));
                Configuration configuration2 = configuration;
                return configuration2;
            }
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
        return null;
    }
}

