/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.file;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.file.DirectoryManager;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DirectoryManagerImpl
implements DirectoryManager {
    @Override
    public void add(RuleFile ruleFile) {
        Connection connection = JdbcUtils.getConnection();
        try {
            ruleFile.setId(IDGenerator.getInstance().nextId(IDType.FILE));
            ruleFile.setModifyDate(new Date());
            ruleFile.setCreateDate(new Date());
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_PACKAGE (ID_, NAME_, TYPE_, PARENT_ID_, PROJECT_ID_, CREATE_USER_, CREATE_DATE_, UPDATE_USER_, UPDATE_DATE_, DELETED_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setLong(1, ruleFile.getId());
            preparedStatement.setString(2, ruleFile.getName());
            preparedStatement.setString(3, ruleFile.getType());
            preparedStatement.setLong(4, ruleFile.getParentId());
            preparedStatement.setLong(5, ruleFile.getProjectId());
            preparedStatement.setString(6, ruleFile.getCreateUser());
            preparedStatement.setTimestamp(7, new Timestamp(ruleFile.getCreateDate().getTime()));
            preparedStatement.setString(8, ruleFile.getCreateUser());
            preparedStatement.setTimestamp(9, new Timestamp(ruleFile.getModifyDate().getTime()));
            preparedStatement.setBoolean(10, ruleFile.isDeleted());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public RuleFile get(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select NAME_, PARENT_ID_, TYPE_, UPDATE_USER_, UPDATE_DATE_, DELETED_, PROJECT_ID_ from URULE_PACKAGE where ID_=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            RuleFile ruleFile = null;
            if (resultSet.next()) {
                ruleFile = new RuleFile();
                ruleFile.setId(l);
                ruleFile.setName(resultSet.getString(1));
                ruleFile.setParentId(resultSet.getLong(2));
                ruleFile.setType(resultSet.getString(3));
                ruleFile.setUpdateUser(resultSet.getString(4));
                ruleFile.setModifyDate(resultSet.getTimestamp(5));
                ruleFile.setDeleted(resultSet.getBoolean(6));
                ruleFile.setProjectId(resultSet.getLong(7));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            RuleFile ruleFile2 = ruleFile;
            return ruleFile2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_PACKAGE where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public RuleFile loadDir(long l, long l2, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select NAME_, PARENT_ID_, TYPE_, UPDATE_USER_, UPDATE_DATE_, DELETED_,ID_ from URULE_PACKAGE where PARENT_ID_=? and PROJECT_ID_=? and TYPE_=? and NAME_=?");
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            RuleFile ruleFile = null;
            if (resultSet.next()) {
                ruleFile = new RuleFile();
                ruleFile.setName(resultSet.getString(1));
                ruleFile.setParentId(resultSet.getLong(2));
                ruleFile.setType(resultSet.getString(3));
                ruleFile.setUpdateUser(resultSet.getString(4));
                ruleFile.setModifyDate(resultSet.getTimestamp(5));
                ruleFile.setDeleted(resultSet.getBoolean(6));
                ruleFile.setId(resultSet.getLong(7));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            RuleFile ruleFile2 = ruleFile;
            return ruleFile2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateDeleteFlag(long l, boolean bl, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_PACKAGE set DELETED_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
            if (bl) {
                preparedStatement.setBoolean(1, bl);
                preparedStatement.setString(2, string);
                preparedStatement.setDate(3, new java.sql.Date(System.currentTimeMillis()));
                preparedStatement.setLong(4, l);
                preparedStatement.executeUpdate();
            } else {
                this.a(preparedStatement, l, string);
            }
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    private void a(PreparedStatement preparedStatement, long l, String string) {
        RuleFile ruleFile = this.get(l);
        if (ruleFile != null && ruleFile.isDeleted() && ruleFile.getParentId() > 0L) {
            this.a(preparedStatement, ruleFile.getParentId(), string);
        }
        try {
            preparedStatement.setBoolean(1, false);
            preparedStatement.setString(2, string);
            preparedStatement.setDate(3, new java.sql.Date(System.currentTimeMillis()));
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public void changeName(long l, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_PACKAGE set NAME_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public boolean checkExist(long l, long l2, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from URULE_PACKAGE where PROJECT_ID_=? and NAME_=? and PARENT_ID_=? and TYPE_=? and DELETED_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string2);
            preparedStatement.setLong(3, l2);
            preparedStatement.setString(4, string);
            preparedStatement.setBoolean(5, false);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            boolean bl = n > 0;
            return bl;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<RuleFile> list(long l, long l2, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_, NAME_, TYPE_ from URULE_PACKAGE where PARENT_ID_=? and PROJECT_ID_=? and TYPE_=? and DELETED_=? order by NAME_ asc");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string);
            preparedStatement.setBoolean(4, false);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new RuleFile();
                ((RuleFile)object).setDirectory(true);
                ((FileInfo)object).setId(resultSet.getLong(1));
                ((RuleFile)object).setParentId(l2);
                ((FileInfo)object).setName(resultSet.getString(2));
                ((RuleFile)object).setType(resultSet.getString(3));
                ((RuleFile)object).setProjectId(l);
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void changeParent(long l, long l2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_PACKAGE set PARENT_ID_=? where ID_=?");
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_PACKAGE where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

