/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.file;

import com.bstek.urule.console.database.manager.file.FileCountQuery;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileCountQueryImpl
implements FileCountQuery {
    private Long a;
    private Date b;
    private Date c;

    @Override
    public FileCountQuery projectId(Long l) {
        this.a = l;
        return this;
    }

    @Override
    public FileCountQuery updateDateBegin(Date date) {
        this.b = date;
        return this;
    }

    @Override
    public FileCountQuery updateDateEnd(Date date) {
        this.c = date;
        return this;
    }

    @Override
    public List<RuleFile> getRuleCommits() {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_, UPDATE_DATE_ from URULE_FILE where PROJECT_ID_=? and UPDATE_DATE_>=? and UPDATE_DATE_<=?");
            preparedStatement.setLong(1, this.a);
            preparedStatement.setTimestamp(2, new Timestamp(this.b.getTime()));
            preparedStatement.setTimestamp(3, new Timestamp(this.c.getTime()));
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (resultSet.next()) {
                object = new RuleFile();
                ((FileInfo)object).setId(resultSet.getLong(1));
                ((RuleFile)object).setModifyDate(resultSet.getTimestamp(2));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<RuleFile> getUserCommits() {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_, UPDATE_USER_, UPDATE_DATE_ from URULE_FILE where PROJECT_ID_=? and UPDATE_DATE_>=? and UPDATE_DATE_<=?");
            preparedStatement.setLong(1, this.a);
            preparedStatement.setTimestamp(2, new Timestamp(this.b.getTime()));
            preparedStatement.setTimestamp(3, new Timestamp(this.c.getTime()));
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (resultSet.next()) {
                object = new RuleFile();
                ((FileInfo)object).setId(resultSet.getLong(1));
                ((RuleFile)object).setUpdateUser(resultSet.getString(2));
                ((RuleFile)object).setModifyDate(resultSet.getDate(3));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public Integer getRuleCount() {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select COUNT(*) RULE_COUNT_ from URULE_FILE where PROJECT_ID_=?");
            preparedStatement.setLong(1, this.a);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            Integer n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

