/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.file;

import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.file.FileCountQuery;
import com.bstek.urule.console.database.manager.file.FileCountQueryImpl;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.file.FileQuery;
import com.bstek.urule.console.database.manager.file.FileQueryImpl;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.MD5Utils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class FileManagerImpl
implements FileManager {
    @Override
    public FileQuery newQuery() {
        return new FileQueryImpl();
    }

    @Override
    public RuleFile get(long l) {
        FileQueryImpl fileQueryImpl = new FileQueryImpl();
        List<RuleFile> list = fileQueryImpl.id(l).list(null);
        if (list.size() == 0) {
            throw new RuleException("File \u3010" + l + "\u3011 not exist!");
        }
        return list.get(0);
    }

    @Override
    public String loadContent(long l) {
        Connection connection = JdbcUtils.getConnection();
        String string = null;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select CONTENT_ from URULE_FILE where ID_=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            String string2 = string;
            return string2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(RuleFile ruleFile) {
        Connection connection = JdbcUtils.getConnection();
        try {
            ruleFile.setId(IDGenerator.getInstance().nextId(IDType.FILE));
            ruleFile.setCreateDate(new java.util.Date(System.currentTimeMillis()));
            ruleFile.setModifyDate(new java.util.Date(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_FILE (ID_, NAME_, TYPE_, PACKAGE_ID_, CONTENT_, CREATE_USER_, CREATE_DATE_,UPDATE_USER_, UPDATE_DATE_,PROJECT_ID_,LATEST_VERSION_,DELETED_) values (?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setLong(1, ruleFile.getId());
            preparedStatement.setString(2, ruleFile.getName());
            preparedStatement.setString(3, ruleFile.getType());
            preparedStatement.setLong(4, ruleFile.getParentId());
            preparedStatement.setString(5, ruleFile.getContent());
            preparedStatement.setString(6, ruleFile.getCreateUser());
            preparedStatement.setTimestamp(7, new Timestamp(ruleFile.getCreateDate().getTime()));
            preparedStatement.setString(8, ruleFile.getCreateUser());
            preparedStatement.setTimestamp(9, new Timestamp(ruleFile.getModifyDate().getTime()));
            preparedStatement.setLong(10, ruleFile.getProjectId());
            preparedStatement.setString(11, ruleFile.getLatestVersion());
            preparedStatement.setBoolean(12, ruleFile.isDeleted());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateContent(long l, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set CONTENT_=?, DIGEST_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, MD5Utils.stringToMD5(string2));
            preparedStatement.setString(3, string);
            preparedStatement.setTimestamp(4, new Timestamp(new java.util.Date().getTime()));
            preparedStatement.setLong(5, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<RuleFile> list(long l, long l2, String string) {
        ArrayList<RuleFile> arrayList = new ArrayList<RuleFile>();
        if (string.contentEquals(ResourceType.Library.name())) {
            arrayList.addAll(this.a(l, l2, ResourceType.VariableLibrary.name()));
            arrayList.addAll(this.a(l, l2, ResourceType.ParameterLibrary.name()));
            arrayList.addAll(this.a(l, l2, ResourceType.ConstantLibrary.name()));
            arrayList.addAll(this.a(l, l2, ResourceType.ActionLibrary.name()));
        } else if (string.contentEquals(ResourceType.DecisionTable.name())) {
            arrayList.addAll(this.a(l, l2, ResourceType.DecisionTable.name()));
            arrayList.addAll(this.a(l, l2, ResourceType.CrossDecisionTable.name()));
        } else if (string.contentEquals(ResourceType.Scorecard.name())) {
            arrayList.addAll(this.a(l, l2, ResourceType.Scorecard.name()));
            arrayList.addAll(this.a(l, l2, ResourceType.ComplexScorecard.name()));
        } else {
            arrayList.addAll(this.a(l, l2, string));
        }
        return arrayList;
    }

    private List<RuleFile> a(long l, long l2, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_,NAME_, TYPE_, CREATE_USER_, LOCKED_USER_, UPDATE_DATE_,DIGEST_ from URULE_FILE where PACKAGE_ID_=? and TYPE_=? and PROJECT_ID_=? and DELETED_=? order by NAME_ asc");
            preparedStatement.setLong(1, l2);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, l);
            preparedStatement.setBoolean(4, false);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new RuleFile();
                ((RuleFile)object).setDirectory(false);
                ((FileInfo)object).setId(resultSet.getLong(1));
                ((FileInfo)object).setName(resultSet.getString(2));
                ((RuleFile)object).setType(resultSet.getString(3));
                ((FileInfo)object).setCreateUser(resultSet.getString(4));
                ((RuleFile)object).setLockedUser(resultSet.getString(5));
                ((RuleFile)object).setModifyDate(resultSet.getTimestamp(6));
                ((RuleFile)object).setDigest(resultSet.getString(7));
                ((RuleFile)object).setParentId(l2);
                ((RuleFile)object).setProjectId(l);
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void changeParent(long l, long l2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set PACKAGE_ID_=? where ID_=?");
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public boolean checkExist(long l, long l2, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from URULE_FILE where PROJECT_ID_=? and NAME_=? and PACKAGE_ID_=? and TYPE_=? and DELETED_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string2);
            preparedStatement.setLong(3, l2);
            preparedStatement.setString(4, string);
            preparedStatement.setBoolean(5, false);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            boolean bl = n > 0;
            return bl;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void rename(long l, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set NAME_=?, UPDATE_USER_=?, UPDATE_DATE_=?  where ID_=?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_FILE where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void lock(long l, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set LOCKED_USER_=?, UPDATE_USER_=?, UPDATE_DATE_=?  where ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void unlock(long l, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set LOCKED_USER_=null, LATEST_VERSION_=?, UPDATE_USER_=?, UPDATE_DATE_=?  where ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateDeleteFlag(long l, boolean bl, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            RuleFile ruleFile = this.get(l);
            if (ruleFile != null) {
                PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set DELETED_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
                preparedStatement.setBoolean(1, bl);
                preparedStatement.setString(2, string);
                preparedStatement.setDate(3, new Date(System.currentTimeMillis()));
                preparedStatement.setLong(4, l);
                preparedStatement.executeUpdate();
                JdbcUtils.closeStatement(preparedStatement);
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_FILE where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public FileCountQuery newCountQuery() {
        return new FileCountQueryImpl();
    }

    @Override
    public void update(RuleFile ruleFile) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_FILE set NAME_=?, TYPE_=?, PACKAGE_ID_=?, CONTENT_=?, CREATE_USER_=?, CREATE_DATE_=?,UPDATE_USER_=?, UPDATE_DATE_=?,PROJECT_ID_=?,LATEST_VERSION_=?,DELETED_=? where ID_=?");
            preparedStatement.setString(1, ruleFile.getName());
            preparedStatement.setString(2, ruleFile.getType());
            preparedStatement.setLong(3, ruleFile.getParentId());
            preparedStatement.setString(4, ruleFile.getContent());
            preparedStatement.setString(5, ruleFile.getCreateUser());
            preparedStatement.setTimestamp(6, new Timestamp(ruleFile.getCreateDate().getTime()));
            preparedStatement.setString(7, ruleFile.getCreateUser());
            preparedStatement.setTimestamp(8, new Timestamp(ruleFile.getModifyDate().getTime()));
            preparedStatement.setLong(9, ruleFile.getProjectId());
            preparedStatement.setString(10, ruleFile.getLatestVersion());
            preparedStatement.setBoolean(11, ruleFile.isDeleted());
            preparedStatement.setLong(12, ruleFile.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

