/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.file.version;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.file.version.VersionFileManager;
import com.bstek.urule.console.database.manager.file.version.VersionFileQuery;
import com.bstek.urule.console.database.manager.file.version.VersionFileQueryImpl;
import com.bstek.urule.console.database.model.VersionFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.MD5Utils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class VersionFileManagerImpl
implements VersionFileManager {
    protected VersionFileManagerImpl() {
    }

    @Override
    public VersionFile loadFile(long l) {
        List<VersionFile> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String loadFileContent(long l) {
        Connection connection = JdbcUtils.getConnection();
        String string = null;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select CONTENT_ from URULE_VERSION_FILE where ID_=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            String string2 = string;
            return string2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public void updateContent(long l, String string) {
        Connection connection = JdbcUtils.getConnection();
        String string2 = "update URULE_VERSION_FILE set CONTENT_=?,DIGEST_=? where ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, MD5Utils.stringToMD5(string));
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public VersionFile loadFile(long l, String string) {
        List<VersionFile> list = this.newQuery().fileId(l).version(string).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<VersionFile> loadFiles(long l) {
        return this.newQuery().fileId(l).list();
    }

    @Override
    public void saveFile(VersionFile versionFile) {
        Connection connection = JdbcUtils.getConnection();
        String string = "insert into URULE_VERSION_FILE(ID_, FILE_ID_, PROJECT_ID_, NAME_, VERSION_, NOTE_, CONTENT_, DIGEST_, CREATE_USER_, CREATE_DATE_) values(?,?,?,?,?,?,?,?,?, ?)";
        long l = IDGenerator.getInstance().nextId(IDType.FILE);
        versionFile.setId(l);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, versionFile.getFileId());
            preparedStatement.setLong(3, versionFile.getProjectId());
            preparedStatement.setString(4, versionFile.getName());
            preparedStatement.setString(5, versionFile.getVersion());
            preparedStatement.setString(6, versionFile.getNote());
            preparedStatement.setString(7, versionFile.getContent());
            preparedStatement.setString(8, MD5Utils.stringToMD5(versionFile.getContent()));
            preparedStatement.setString(9, versionFile.getCreateUser());
            preparedStatement.setTimestamp(10, new Timestamp(new Date().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public VersionFileQuery newQuery() {
        return new VersionFileQueryImpl();
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_VERSION_FILE where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByFileId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_VERSION_FILE where FILE_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

