/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.group;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.group.GroupQuery;
import com.bstek.urule.console.database.manager.group.GroupQueryImpl;
import com.bstek.urule.console.database.manager.group.user.UserQuery;
import com.bstek.urule.console.database.manager.group.user.UserQueryImpl;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class GroupManagerImpl
implements GroupManager {
    @Override
    public Group get(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "SELECT ID_, NAME_, CREATE_USER_, CREATE_DATE_, DESC_ FROM URULE_GROUP  WHERE URULE_GROUP.ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            Group group = null;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                group = new Group();
                group.setId(resultSet.getString(1));
                group.setName(resultSet.getString(2));
                group.setCreateUser(resultSet.getString(3));
                group.setCreateDate(resultSet.getTimestamp(4));
                group.setDesc(resultSet.getString(5));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            Group group2 = group;
            return group2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(Group group) {
        Connection connection = JdbcUtils.getConnection();
        try {
            group.setCreateDate(new Timestamp(System.currentTimeMillis()));
            group.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_GROUP (ID_, NAME_, DESC_, CREATE_USER_,CREATE_DATE_) values (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, group.getId());
            preparedStatement.setString(2, group.getName());
            preparedStatement.setString(3, group.getDesc());
            preparedStatement.setString(4, group.getCreateUser());
            preparedStatement.setTimestamp(5, new Timestamp(group.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(Group group) {
        Connection connection = JdbcUtils.getConnection();
        try {
            group.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_GROUP set NAME_=?, DESC_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, group.getName());
            preparedStatement.setString(2, group.getDesc());
            preparedStatement.setString(3, group.getUpdateUser());
            preparedStatement.setTimestamp(4, new Timestamp(group.getUpdateDate().getTime()));
            preparedStatement.setString(5, group.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_GROUP where ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void addGroupUser(String string, String string2, String string3) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO URULE_GROUP_USER (ID_, GROUP_ID_, USER_ID_, USER_NAME_) VALUES (?, ?, ?, ?)");
            preparedStatement.setLong(1, IDGenerator.getInstance().nextId(IDType.GROUP_USER));
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string3);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public int count() {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "SELECT count(*) GROUP_COUNT_ FROM URULE_GROUP";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeGroupUser(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_GROUP_USER where GROUP_ID_=? AND USER_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeGroupUsers(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_GROUP_USER where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<User> getUsers(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string2 = "SELECT USER_ID_, CREATE_DATE_ FROM URULE_GROUP_USER  WHERE GROUP_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new User();
                ((User)object).setId(resultSet.getString(1));
                ((User)object).setCreateDate(resultSet.getTimestamp(2));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public GroupQuery createQuery() {
        return new GroupQueryImpl();
    }

    @Override
    public UserQuery createUserQuery() {
        return new UserQueryImpl();
    }

    @Override
    public User getGroupUser(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string3 = "SELECT USER_ID_, CREATE_DATE_ FROM URULE_GROUP_USER  WHERE GROUP_ID_=? and USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            User user = null;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                user = new User();
                user.setId(resultSet.getString(1));
                user.setCreateDate(resultSet.getTimestamp(2));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            User user2 = user;
            return user2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

