/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.group.role;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.group.role.GroupRoleManager;
import com.bstek.urule.console.database.model.GroupRole;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.model.UserRole;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class GroupRoleManagerImpl
implements GroupRoleManager {
    @Override
    public List<Role> loadRoles(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string2 = "select ID_, NAME_, TYPE_, CREATE_DATE_, UPDATE_DATE_ from URULE_GROUP_ROLE WHERE GROUP_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new GroupRole();
                ((Role)object).setId(resultSet.getLong(1));
                ((Role)object).setName(resultSet.getString(2));
                ((Role)object).setType(resultSet.getString(3));
                ((Role)object).setCreateDate(resultSet.getTimestamp(4));
                ((Role)object).setUpdateDate(resultSet.getTimestamp(5));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<Role> loadUserRoles(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string3 = "select URULE_GROUP_ROLE.ID_, URULE_GROUP_ROLE.NAME_, URULE_GROUP_ROLE.TYPE_ from URULE_GROUP_ROLE  LEFT JOIN URULE_GROUP_USER_ROLE  ON URULE_GROUP_ROLE.ID_=URULE_GROUP_USER_ROLE.ROLE_ID_ WHERE URULE_GROUP_ROLE.GROUP_ID_=? AND URULE_GROUP_USER_ROLE.USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new GroupRole();
                ((Role)object).setId(resultSet.getLong(1));
                ((Role)object).setName(resultSet.getString(2));
                ((Role)object).setType(resultSet.getString(3));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<User> loadRoleUsers(String string, long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string2 = "select URULE_GROUP_USER.USER_ID_, URULE_GROUP_USER.USER_NAME_ from URULE_GROUP_USER LEFT JOIN URULE_GROUP_USER_ROLE on URULE_GROUP_USER_ROLE.USER_ID_=URULE_GROUP_USER.USER_ID_ WHERE URULE_GROUP_USER.GROUP_ID_=? and URULE_GROUP_USER_ROLE.ROLE_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new User();
                ((User)object).setId(resultSet.getString(1));
                ((User)object).setName(resultSet.getString(2));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(GroupRole groupRole) {
        Connection connection = JdbcUtils.getConnection();
        try {
            groupRole.setCreateDate(new Timestamp(System.currentTimeMillis()));
            groupRole.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.GROUP_ROLE);
            groupRole.setId(l);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_GROUP_ROLE (ID_, NAME_, TYPE_, GROUP_ID_, CREATE_USER_, CREATE_DATE_,UPDATE_DATE_) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setLong(1, groupRole.getId());
            preparedStatement.setString(2, groupRole.getName());
            preparedStatement.setString(3, groupRole.getType());
            preparedStatement.setString(4, groupRole.getGroupId());
            preparedStatement.setString(5, groupRole.getCreateUser());
            preparedStatement.setTimestamp(6, new Timestamp(groupRole.getCreateDate().getTime()));
            preparedStatement.setTimestamp(7, new Timestamp(groupRole.getUpdateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(GroupRole groupRole) {
        Connection connection = JdbcUtils.getConnection();
        try {
            groupRole.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_GROUP_ROLE set NAME_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, groupRole.getName());
            preparedStatement.setTimestamp(2, new Timestamp(groupRole.getUpdateDate().getTime()));
            preparedStatement.setLong(3, groupRole.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_GROUP_ROLE where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public boolean checkExist(String string, String string2) {
        boolean bl = false;
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_ FROM URULE_GROUP_ROLE where GROUP_ID_=? and NAME_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
        return bl;
    }

    @Override
    public void addUserRole(String string, String string2, long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            long l2 = IDGenerator.getInstance().nextId(IDType.GROUP_USER_ROLE);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_GROUP_USER_ROLE (ID_, GROUP_ID_, USER_ID_, ROLE_ID_) values (?, ?, ?, ?)");
            preparedStatement.setLong(1, l2);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeUserRole(String string, String string2, long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_GROUP_USER_ROLE WHERE USER_ID_=? and ROLE_ID_=? and GROUP_ID_=?");
            preparedStatement.setString(1, string2);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public GroupRole get(long l) {
        GroupRole groupRole = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "select ID_, NAME_, TYPE_, GROUP_ID_, CREATE_DATE_, UPDATE_DATE_ from URULE_GROUP_ROLE WHERE ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                groupRole = new GroupRole();
                groupRole.setId(resultSet.getLong(1));
                groupRole.setName(resultSet.getString(2));
                groupRole.setType(resultSet.getString(3));
                groupRole.setGroupId(resultSet.getString(4));
                groupRole.setCreateDate(resultSet.getTimestamp(5));
                groupRole.setUpdateDate(resultSet.getTimestamp(6));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            GroupRole groupRole2 = groupRole;
            return groupRole2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeRoleUsers(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_GROUP_USER_ROLE WHERE ROLE_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeUserRoles(String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_GROUP_USER_ROLE WHERE USER_ID_=? and GROUP_ID_=?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public GroupRole get(String string, String string2) {
        GroupRole groupRole = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string3 = "select ID_, NAME_, TYPE_, CREATE_DATE_, UPDATE_DATE_ from URULE_GROUP_ROLE WHERE GROUP_ID_=? and NAME_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                groupRole = new GroupRole();
                groupRole.setId(resultSet.getLong(1));
                groupRole.setName(resultSet.getString(2));
                groupRole.setType(resultSet.getString(3));
                groupRole.setCreateDate(resultSet.getTimestamp(4));
                groupRole.setUpdateDate(resultSet.getTimestamp(5));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            GroupRole groupRole2 = groupRole;
            return groupRole2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public UserRole getUserRole(String string, long l) {
        UserRole userRole = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select ID_, ROLE_ID_, USER_ID_ from URULE_GROUP_USER_ROLE WHERE ROLE_ID_=? and USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                userRole = new UserRole();
                userRole.setId(resultSet.getLong(1));
                userRole.setRoleId(resultSet.getLong(2));
                userRole.setUserId(resultSet.getString(3));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            UserRole userRole2 = userRole;
            return userRole2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_GROUP_USER_ROLE where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("delete FROM URULE_GROUP_ROLE where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

