/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.jar;

import com.bstek.urule.Utils;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.jar.DynamicJarManager;
import com.bstek.urule.console.database.manager.jar.DynamicJarQuery;
import com.bstek.urule.console.database.manager.jar.DynamicJarQueryImpl;
import com.bstek.urule.console.database.model.DynamicJar;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.MD5Utils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.DynamicSpringConfigLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class DynamicJarManagerImpl
implements DynamicJarManager {
    protected DynamicJarManagerImpl() {
    }

    @Override
    public int createJarFiles(String string) {
        DynamicJar dynamicJar2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        List<DynamicJar> list = DynamicJarManager.ins.newQuery().list();
        for (DynamicJar dynamicJar2 : list) {
            byte[] byArray = DynamicJarManager.ins.loadJar(dynamicJar2.getId());
            if (byArray == null) continue;
            ++n;
            this.a(dynamicJar2.getName(), byArray, string);
            stringBuilder.append(dynamicJar2.getId());
        }
        String string2 = MD5Utils.stringToMD5(stringBuilder.toString());
        dynamicJar2 = (DynamicSpringConfigLoader)Utils.getApplicationContext().getBean("urule.dynamicSpringConfigLoader");
        dynamicJar2.resetDynamicJarsIdDigest(string2);
        return n;
    }

    private void a(String string, byte[] byArray, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            String string3 = string2 + "/" + string;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            File file2 = new File(string3);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            IOUtils.closeQuietly((InputStream)byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    @Override
    public byte[] loadJar(long l) {
        String string = "select JAR_ from URULE_DYNAMIC_JAR where ID_=?";
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] byArray = null;
            if (resultSet.next()) {
                byArray = resultSet.getBytes(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public DynamicJar load(long l) {
        List<DynamicJar> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(DynamicJar dynamicJar) {
        Connection connection = JdbcUtils.getConnection();
        try {
            dynamicJar.setCreateDate(new Date());
            dynamicJar.setUpdateDate(new Date());
            dynamicJar.setId(IDGenerator.getInstance().nextId(IDType.DYNAMIC_JAR));
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_DYNAMIC_JAR(ID_, NAME_,DESC_, CREATE_DATE_, UPDATE_DATE_,CREATE_USER_,UPDATE_USER_,GROUP_ID_) values (?, ?, ?, ?, ?, ?, ?,?)");
            preparedStatement.setLong(1, dynamicJar.getId());
            preparedStatement.setString(2, dynamicJar.getName());
            preparedStatement.setString(3, dynamicJar.getDesc());
            preparedStatement.setTimestamp(4, new Timestamp(dynamicJar.getCreateDate().getTime()));
            preparedStatement.setTimestamp(5, new Timestamp(dynamicJar.getUpdateDate().getTime()));
            preparedStatement.setString(6, dynamicJar.getCreateUser());
            preparedStatement.setString(7, dynamicJar.getCreateUser());
            preparedStatement.setString(8, dynamicJar.getGroupId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(DynamicJar dynamicJar) {
        Connection connection = JdbcUtils.getConnection();
        try {
            dynamicJar.setUpdateDate(new Date());
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_DYNAMIC_JAR set DESC_=?, UPDATE_DATE_=? , UPDATE_USER_=? where ID_=?");
            preparedStatement.setString(1, dynamicJar.getDesc());
            preparedStatement.setTimestamp(2, new Timestamp(dynamicJar.getUpdateDate().getTime()));
            preparedStatement.setString(3, dynamicJar.getUpdateUser());
            preparedStatement.setLong(4, dynamicJar.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_DYNAMIC_JAR where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateJar(long l, String string, String string2, byte[] byArray) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_DYNAMIC_JAR set NAME_=?,JAR_=?,UPDATE_DATE_=? , UPDATE_USER_=?  where ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
            preparedStatement.setString(4, string2);
            preparedStatement.setLong(5, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public DynamicJarQuery newQuery() {
        return new DynamicJarQueryImpl();
    }
}

