/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.log;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.log.KnowledgeLogCountQuery;
import com.bstek.urule.console.database.manager.log.KnowledgeLogCountQueryImpl;
import com.bstek.urule.console.database.manager.log.KnowledgeLogManager;
import com.bstek.urule.console.database.manager.log.KnowledgeLogQuery;
import com.bstek.urule.console.database.manager.log.KnowledgeLogQueryImpl;
import com.bstek.urule.console.database.model.KnowledgeLog;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class KnowledgeLogManagerImpl
implements KnowledgeLogManager {
    @Override
    public void add(KnowledgeLog knowledgeLog) {
        Connection connection = JdbcUtils.getConnection();
        try {
            knowledgeLog.setCreateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.LOG_KNOWLEDGE);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_LOG_KNOWLEDGE (ID_, USER_, KNOWLEDGE_ID_, KNOWLEDGE_NAME_, VERSION_, IN_PARAMS_, OUT_PARAMS_, LOGS_, TIME_, IP_, USER_AGENT_, START_TIME_, END_TIME_, GROUP_ID_, GROUP_NAME_, PROJECT_ID_, PROJECT_NAME_, CREATE_DATE_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            knowledgeLog.setId(l);
            preparedStatement.setLong(1, knowledgeLog.getId());
            preparedStatement.setString(2, knowledgeLog.getUsername());
            preparedStatement.setLong(3, knowledgeLog.getKnowledgeId());
            preparedStatement.setString(4, knowledgeLog.getKnowledgeName());
            preparedStatement.setString(5, knowledgeLog.getVersion());
            preparedStatement.setString(6, knowledgeLog.getInParams());
            preparedStatement.setString(7, knowledgeLog.getOutParams());
            preparedStatement.setString(8, knowledgeLog.getLogs());
            preparedStatement.setLong(9, knowledgeLog.getTime());
            preparedStatement.setString(10, knowledgeLog.getIp());
            preparedStatement.setString(11, knowledgeLog.getUserAgent());
            preparedStatement.setTimestamp(12, new Timestamp(knowledgeLog.getStartTime().getTime()));
            preparedStatement.setTimestamp(13, new Timestamp(knowledgeLog.getEndTime().getTime()));
            preparedStatement.setString(14, knowledgeLog.getGroupId());
            preparedStatement.setString(15, knowledgeLog.getGroupName());
            preparedStatement.setLong(16, knowledgeLog.getProjectId());
            preparedStatement.setString(17, knowledgeLog.getProjectName());
            preparedStatement.setTimestamp(18, new Timestamp(knowledgeLog.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByProject(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_KNOWLEDGE where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_KNOWLEDGE where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public KnowledgeLogQuery newQuery() {
        return new KnowledgeLogQueryImpl();
    }

    @Override
    public KnowledgeLogCountQuery newCountQuery() {
        return new KnowledgeLogCountQueryImpl();
    }
}

