/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.log;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.log.LoginLogManager;
import com.bstek.urule.console.database.manager.log.LoginLogQuery;
import com.bstek.urule.console.database.manager.log.LoginLogQueryImpl;
import com.bstek.urule.console.database.model.LoginLog;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class LoginLogManagerImpl
implements LoginLogManager {
    @Override
    public void add(LoginLog loginLog) {
        Connection connection = JdbcUtils.getConnection();
        try {
            loginLog.setCreateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.LOG_USERLOGIN);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_LOG_USERLOGIN (ID_, USER_ID_, USER_NAME_, IP_, USER_AGENT_, CREATE_DATE_) values (?, ?, ?, ?, ?, ?)");
            loginLog.setId(l);
            preparedStatement.setLong(1, loginLog.getId());
            preparedStatement.setString(2, loginLog.getUserId());
            preparedStatement.setString(3, loginLog.getUsername());
            preparedStatement.setString(4, loginLog.getIp());
            preparedStatement.setString(5, loginLog.getUserAgent());
            preparedStatement.setTimestamp(6, new Timestamp(loginLog.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByUser(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_USERLOGIN where USER_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public LoginLogQuery newQuery() {
        return new LoginLogQueryImpl();
    }
}

