/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.log;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.log.OperationLogManager;
import com.bstek.urule.console.database.manager.log.OperationLogQuery;
import com.bstek.urule.console.database.manager.log.OperationLogQueryImpl;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.OperationLog;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class OperationLogManagerImpl
implements OperationLogManager {
    @Override
    public void add(OperationLog operationLog) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Project project;
            Group group;
            operationLog.setCreateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.LOG_OPERATION);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_LOG_OPERATION (ID_, USER_ID_, USER_NAME_, GROUP_ID_, GROUP_NAME_, PROJECT_ID_, PROJECT_NAME_, CATEGORY_, ACTION_, ITEM_ID_, CONTENT_, CREATE_DATE_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            operationLog.setId(l);
            preparedStatement.setLong(1, operationLog.getId());
            preparedStatement.setString(2, operationLog.getUserId());
            preparedStatement.setString(3, operationLog.getUsername());
            preparedStatement.setString(4, operationLog.getGroupId());
            preparedStatement.setString(5, operationLog.getGroupName());
            if (StringUtils.isBlank(operationLog.getGroupId()) && operationLog.getProjectId() != null && null != (group = GroupManager.ins.get((project = ProjectManager.ins.get(operationLog.getProjectId())).getGroupId()))) {
                preparedStatement.setString(4, group.getId());
                preparedStatement.setString(5, group.getName());
            }
            if (operationLog.getProjectId() == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, operationLog.getProjectId());
            }
            preparedStatement.setString(7, operationLog.getProjectName());
            preparedStatement.setString(8, operationLog.getCategory());
            preparedStatement.setString(9, operationLog.getAction());
            preparedStatement.setString(10, operationLog.getItemId());
            preparedStatement.setString(11, operationLog.getContent());
            preparedStatement.setTimestamp(12, new Timestamp(operationLog.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_OPERATION where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_OPERATION where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public OperationLogQuery newQuery() {
        return new OperationLogQueryImpl();
    }
}

