/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.log.batch;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.log.batch.BatchLogManager;
import com.bstek.urule.console.database.manager.log.batch.BatchLogQuery;
import com.bstek.urule.console.database.manager.log.batch.BatchLogQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchLog;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class BatchLogManagerImpl
implements BatchLogManager {
    @Override
    public void updateStatus(BatchLog batchLog) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_LOG_BATCH set STATUS_=?, END_TIME_=?, TIME_=?, MSG_=?, ITEM_DATA_=?, READ_COUNT_=?, FILTER_COUNT_=? where ID_=?");
            preparedStatement.setString(1, batchLog.getStatus().name());
            preparedStatement.setTimestamp(2, new Timestamp(batchLog.getEndTime().getTime()));
            preparedStatement.setLong(3, batchLog.getEndTime().getTime() - batchLog.getStartTime().getTime());
            preparedStatement.setString(4, batchLog.getMsg());
            preparedStatement.setString(5, batchLog.getItemData());
            preparedStatement.setInt(6, batchLog.getReadCount());
            preparedStatement.setInt(7, batchLog.getFilterCount());
            preparedStatement.setLong(8, batchLog.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(BatchLog batchLog) {
        Connection connection = JdbcUtils.getConnection();
        try {
            batchLog.setCreateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.LOG_BATCH);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_LOG_BATCH (ID_, USER_, IP_, USER_AGENT_, BATCH_ID_, BATCH_NAME_, STATUS_, READ_COUNT_, FILTER_COUNT_, ITEM_DATA_, IN_PARAMS_, PACKET_ID_, PACKET_PARAMS_, START_TIME_, END_TIME_, TIME_, MSG_, DETAIL_, GROUP_ID_, GROUP_NAME_, PROJECT_ID_, PROJECT_NAME_, CREATE_DATE_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            batchLog.setId(l);
            preparedStatement.setLong(1, batchLog.getId());
            preparedStatement.setString(2, batchLog.getUserId());
            preparedStatement.setString(3, batchLog.getIp());
            preparedStatement.setString(4, batchLog.getUserAgent());
            preparedStatement.setLong(5, batchLog.getBatchId());
            preparedStatement.setString(6, batchLog.getBatchName());
            preparedStatement.setString(7, batchLog.getStatus().name());
            preparedStatement.setInt(8, batchLog.getReadCount());
            preparedStatement.setInt(9, batchLog.getFilterCount());
            preparedStatement.setString(10, batchLog.getItemData());
            preparedStatement.setString(11, batchLog.getInParams());
            preparedStatement.setLong(12, batchLog.getPacketId());
            preparedStatement.setString(13, batchLog.getPacketParams());
            preparedStatement.setTimestamp(14, new Timestamp(batchLog.getStartTime().getTime()));
            if (null == batchLog.getEndTime()) {
                preparedStatement.setObject(15, null);
                preparedStatement.setObject(16, null);
            } else {
                preparedStatement.setTimestamp(15, new Timestamp(batchLog.getEndTime().getTime()));
                preparedStatement.setLong(16, batchLog.getEndTime().getTime() - batchLog.getStartTime().getTime());
            }
            preparedStatement.setString(17, batchLog.getMsg());
            preparedStatement.setString(18, batchLog.getDetail());
            preparedStatement.setString(19, batchLog.getGroupId());
            preparedStatement.setString(20, batchLog.getGroupName());
            preparedStatement.setLong(21, batchLog.getProjectId());
            preparedStatement.setString(22, batchLog.getProjectName());
            preparedStatement.setTimestamp(23, new Timestamp(batchLog.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_BATCH where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByProject(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_BATCH where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public BatchLogQuery newQuery() {
        return new BatchLogQueryImpl();
    }
}

