/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.log.batch;

import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.database.manager.log.batch.BatchLogQuery;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.batch.BatchLog;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BatchLogQueryImpl
implements BatchLogQuery {
    private String a;
    private Long b;
    private Long c;
    private String d;
    private String e;
    private Date f;
    private Date g;
    private Boolean h;
    private String i;
    private String j;
    private List<Object> k = new ArrayList<Object>();

    @Override
    public BatchLogQuery groupId(String string) {
        this.a = string;
        return this;
    }

    @Override
    public BatchLogQuery projectId(Long l) {
        this.b = l;
        return this;
    }

    @Override
    public BatchLogQuery batchId(Long l) {
        this.c = l;
        return this;
    }

    @Override
    public BatchLogQuery user(String string) {
        this.d = string;
        return this;
    }

    @Override
    public BatchLogQuery batchNameLike(String string) {
        this.e = string;
        return this;
    }

    @Override
    public BatchLogQuery dateBegin(Date date) {
        this.f = date;
        return this;
    }

    @Override
    public BatchLogQuery dateEnd(Date date) {
        this.g = date;
        return this;
    }

    @Override
    public Page<BatchLog> paging(int n, int n2) {
        String string = "select ID_, USER_, BATCH_ID_, BATCH_NAME_, STATUS_, TIME_, PROJECT_ID_, GROUP_ID_, IP_, USER_AGENT_, START_TIME_, END_TIME_, CREATE_DATE_, READ_COUNT_, FILTER_COUNT_ from URULE_LOG_BATCH";
        Connection connection = JdbcUtils.getConnection();
        try {
            StringBuilder stringBuilder = this.a();
            if (stringBuilder.length() > 0) {
                string = string + " where" + stringBuilder.toString();
            }
            string = this.h != null ? string + " order by TIME_ desc" : string + " order by CREATE_DATE_ desc";
            Page<BatchLog> page = new Page<BatchLog>(n, n2);
            string = JdbcUtils.getPageSql(connection, string, page.getStartRow(), n2);
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            JdbcUtils.fillPreparedStatementParameters(this.k, preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<BatchLog> list = this.a(resultSet);
            page.setData(list);
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            string = "select count(*) from URULE_LOG_BATCH";
            if (stringBuilder.length() > 0) {
                string = string + " where" + stringBuilder.toString();
            }
            preparedStatement = connection.prepareStatement(string);
            JdbcUtils.fillPreparedStatementParameters(this.k, preparedStatement);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                page.setTotalRows(resultSet.getLong(1));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            Page<BatchLog> page2 = page;
            return page2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    private List<BatchLog> a(ResultSet resultSet) throws Exception {
        ArrayList<BatchLog> arrayList = new ArrayList<BatchLog>();
        while (resultSet.next()) {
            BatchLog batchLog = new BatchLog();
            batchLog.setId(resultSet.getLong(1));
            batchLog.setUserId(resultSet.getString(2));
            batchLog.setUsername(batchLog.getUserId());
            batchLog.setBatchId(resultSet.getLong(3));
            batchLog.setBatchName(resultSet.getString(4));
            batchLog.setStatus(BatchStatus.valueOf(resultSet.getString(5)));
            batchLog.setTime(resultSet.getLong(6));
            batchLog.setProjectId(resultSet.getLong(7));
            batchLog.setGroupId(resultSet.getString(8));
            batchLog.setIp(resultSet.getString(9));
            batchLog.setUserAgent(resultSet.getString(10));
            batchLog.setStartTime(resultSet.getTimestamp(11));
            batchLog.setEndTime(resultSet.getTimestamp(12));
            batchLog.setCreateDate(resultSet.getTimestamp(13));
            batchLog.setReadCount(resultSet.getInt(14));
            batchLog.setFilterCount(resultSet.getInt(15));
            arrayList.add(batchLog);
        }
        return arrayList;
    }

    private StringBuilder a() throws SQLException {
        this.k.clear();
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.d)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" USER_ like ?");
            this.k.add("%" + this.d + "%");
        }
        if (StringUtils.isNotBlank(this.i)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" IP_ = ?");
            this.k.add(this.i);
        }
        if (this.b != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" PROJECT_ID_ = ?");
            this.k.add(this.b);
        }
        if (StringUtils.isNotBlank(this.a)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" GROUP_ID_ = ?");
            this.k.add(this.a);
        }
        if (this.c != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" BATCH_ID_ = ?");
            this.k.add(this.c);
        }
        if (this.j != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" STATUS_ = ?");
            this.k.add(this.j);
        }
        if (StringUtils.isNotBlank(this.e)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" BATCH_NAME_ like ?");
            this.k.add("%" + this.e + "%");
        }
        if (this.f != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" START_TEIM_ > ?");
            this.k.add(this.f);
        }
        if (this.g != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" END_TIME_ < ?");
            this.k.add(this.g);
        }
        return stringBuilder;
    }

    @Override
    public BatchLogQuery orderTime() {
        this.h = true;
        return this;
    }

    @Override
    public BatchLogQuery ip(String string) {
        this.i = string;
        return this;
    }

    @Override
    public BatchLogQuery status(String string) {
        this.j = string;
        return this;
    }

    @Override
    public BatchLog details(Long l) {
        String string = "select IN_PARAMS_, MSG_, DETAIL_, ITEM_DATA_, PACKET_ID_, PACKET_PARAMS_ from URULE_LOG_BATCH WHERE ID_=?";
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            BatchLog batchLog = new BatchLog();
            if (resultSet.next()) {
                batchLog.setInParams(resultSet.getString(1));
                batchLog.setMsg(resultSet.getString(2));
                batchLog.setDetail(resultSet.getString(3));
                batchLog.setItemData(resultSet.getString(4));
                batchLog.setPacketId(resultSet.getLong(5));
                batchLog.setPacketParams(resultSet.getString(6));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            BatchLog batchLog2 = batchLog;
            return batchLog2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

