/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.log.batch;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.log.batch.BatchSkipLogManager;
import com.bstek.urule.console.database.manager.log.batch.BatchSkipLogQuery;
import com.bstek.urule.console.database.manager.log.batch.BatchSkipLogQueryImpl;
import com.bstek.urule.console.database.model.batch.BatchSkipLog;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;

public class BatchSkipLogManagerImpl
implements BatchSkipLogManager {
    @Override
    public void add(BatchSkipLog batchSkipLog) {
        Connection connection = JdbcUtils.getConnection();
        try {
            batchSkipLog.setCreateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.LOG_BATCH_SKIP);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_LOG_BATCH_SKIP (ID_, LOG_ID_, BATCH_ID_, TYPE_, MSG_, DETAIL_, DATA_, GROUP_ID_, PROJECT_ID_, CREATE_DATE_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            batchSkipLog.setId(l);
            preparedStatement.setLong(1, batchSkipLog.getId());
            preparedStatement.setLong(2, batchSkipLog.getLogId());
            preparedStatement.setLong(3, batchSkipLog.getBatchId());
            preparedStatement.setString(4, batchSkipLog.getType());
            preparedStatement.setString(5, batchSkipLog.getMsg());
            preparedStatement.setString(6, batchSkipLog.getDetail());
            preparedStatement.setString(7, batchSkipLog.getData());
            preparedStatement.setString(8, batchSkipLog.getGroupId());
            preparedStatement.setLong(9, batchSkipLog.getProjectId());
            preparedStatement.setTimestamp(10, new Timestamp(batchSkipLog.getCreateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_BATCH_SKIP where GROUP_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByProject(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_LOG_BATCH_SKIP where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public BatchSkipLogQuery newQuery() {
        return new BatchSkipLogQueryImpl();
    }
}

