/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.KnowledgePackage;
import java.io.IOException;
import java.util.List;

public class PacketBuilder {
    public static final PacketBuilder ins = new PacketBuilder();

    private PacketBuilder() {
    }

    public KnowledgePackage buildKnowledgePackage(long l) {
        return this.buildKnowledgeBase(l).getKnowledgePackage();
    }

    public KnowledgeBase buildKnowledgeBase(long l) {
        Packet packet = PacketManager.ins.load(l);
        if (packet == null) {
            throw new RuleException("\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        if (!packet.isEnable()) {
            throw new RuleException("\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u672a\u542f\u7528");
        }
        List<PacketFile> list = packet.getFiles();
        if (list == null || list.size() == 0) {
            throw new RuleException("\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u4e0b\u672a\u5b9a\u4e49\u89c4\u5219\u6587\u4ef6\uff01");
        }
        KnowledgeBuilder knowledgeBuilder = ServiceUtils.getKnowledgeBuilder();
        ResourceBase resourceBase = knowledgeBuilder.newResourceBase();
        for (PacketFile packetFile : list) {
            resourceBase.addResource(packetFile.getFileId(), packetFile.getVersion());
        }
        try {
            return knowledgeBuilder.buildKnowledgeBase(resourceBase);
        }
        catch (IOException iOException) {
            throw new RuleException((Exception)iOException);
        }
    }

    public KnowledgePackage buildKnowledgePackage(long l, String string) {
        PacketDeploy packetDeploy = this.a(l, string);
        String string2 = packetDeploy.getContent();
        return Utils.stringToKnowledgePackage((String)string2);
    }

    private PacketDeploy a(long l, String string) {
        List<PacketDeploy> list = PacketDeployManager.ins.newQuery().packetId(l).version(string).listWithContent();
        if (list.size() == 0) {
            throw new RuleException("\u77e5\u8bc6\u5305\u3010" + l + "\u3011\u4e2d\u53d1\u5e03\u7684\u7248\u672c\u4e3a\u3010" + string + "\u3011\u7684\u77e5\u8bc6\u5305\u4e0d\u5b58\u5728\uff01");
        }
        PacketDeploy packetDeploy = list.get(0);
        return packetDeploy;
    }
}

