/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.PacketQuery;
import com.bstek.urule.console.database.manager.packet.PacketQueryImpl;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyManager;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.file.PacketFileManager;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PacketManagerImpl
implements PacketManager {
    protected PacketManagerImpl() {
    }

    @Override
    public Packet load(long l) {
        List<Packet> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Packet load(String string) {
        List<Packet> list = this.newQuery().code(string).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(Packet packet) {
        Connection connection = JdbcUtils.getConnection();
        try {
            packet.setCreateDate(new Date());
            packet.setUpdateDate(new Date());
            String string = "insert into URULE_PACKET(ID_,PROJECT_ID_,NAME_,CODE_,TYPE_,DESC_,INPUT_DATA_,OUTPUT_DATA_,ENABLE_,CREATE_USER_,UPDATE_USER_,CREATE_DATE_,UPDATE_DATE_,REST_INPUT_,REST_OUTPUT_,AUDIT_ENABLE_,AUDIT_INPUT_,AUDIT_OUTPUT_,REST_ENABLE_,REST_SECURITY_ENABLE_,REST_SECURITY_USER_,REST_SECURITY_PASSWORD_) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            packet.setId(IDGenerator.getInstance().nextId(IDType.PACKET));
            preparedStatement.setLong(1, packet.getId());
            preparedStatement.setLong(2, packet.getProjectId());
            preparedStatement.setString(3, packet.getName());
            if (StringUtils.isBlank(packet.getCode())) {
                packet.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            preparedStatement.setString(4, packet.getCode());
            preparedStatement.setString(5, packet.getType().name());
            preparedStatement.setString(6, packet.getDesc());
            preparedStatement.setString(7, packet.getInputData());
            preparedStatement.setString(8, packet.getOutputData());
            preparedStatement.setBoolean(9, packet.isEnable());
            preparedStatement.setString(10, packet.getCreateUser());
            preparedStatement.setString(11, packet.getCreateUser());
            preparedStatement.setTimestamp(12, new Timestamp(packet.getCreateDate().getTime()));
            preparedStatement.setTimestamp(13, new Timestamp(packet.getUpdateDate().getTime()));
            preparedStatement.setString(14, packet.getRestInput());
            preparedStatement.setString(15, packet.getRestOutput());
            preparedStatement.setBoolean(16, packet.isAuditEnable());
            preparedStatement.setString(17, packet.getAuditInput());
            preparedStatement.setString(18, packet.getAuditOutput());
            preparedStatement.setBoolean(19, packet.isRestEnable());
            preparedStatement.setBoolean(20, packet.isRestSecurityEnable());
            preparedStatement.setString(21, packet.getRestSecurityUser());
            preparedStatement.setString(22, packet.getRestSecurityPassword());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
            PacketFileManager.ins.deleteByPacketId(l);
            PacketApplyManager.ins.deleteByPacketId(l);
            PacketDeployManager.ins.deleteByPacketId(l);
            PacketPackageManager.ins.deleteByPacketId(l);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(Packet packet) {
        Connection connection = JdbcUtils.getConnection();
        try {
            packet.setUpdateDate(new Date());
            String string = "update URULE_PACKET set NAME_=?,CODE_=?,DESC_=?,INPUT_DATA_=?,OUTPUT_DATA_=?,ENABLE_=?,UPDATE_DATE_=?,UPDATE_USER_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, packet.getName());
            if (StringUtils.isBlank(packet.getCode())) {
                packet.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            preparedStatement.setString(2, packet.getCode());
            preparedStatement.setString(3, packet.getDesc());
            preparedStatement.setString(4, packet.getInputData());
            preparedStatement.setString(5, packet.getOutputData());
            preparedStatement.setBoolean(6, packet.isEnable());
            preparedStatement.setTimestamp(7, new Timestamp(packet.getUpdateDate().getTime()));
            preparedStatement.setString(8, packet.getUpdateUser());
            preparedStatement.setLong(9, packet.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(long l, boolean bl) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET set ENABLE_=?,UPDATE_DATE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setTimestamp(2, new Timestamp(new Date().getTime()));
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateRestConfig(Packet packet) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET set REST_SECURITY_ENABLE_=?,REST_SECURITY_USER_=?,REST_SECURITY_PASSWORD_=?,REST_INPUT_=?,REST_OUTPUT_=?,UPDATE_DATE_=?,UPDATE_USER_=?,REST_ENABLE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBoolean(1, packet.isRestSecurityEnable());
            preparedStatement.setString(2, packet.getRestSecurityUser());
            preparedStatement.setString(3, packet.getRestSecurityPassword());
            preparedStatement.setString(4, packet.getRestInput());
            preparedStatement.setString(5, packet.getRestOutput());
            preparedStatement.setTimestamp(6, new Timestamp(packet.getUpdateDate().getTime()));
            preparedStatement.setString(7, packet.getUpdateUser());
            preparedStatement.setBoolean(8, packet.isRestEnable());
            preparedStatement.setLong(9, packet.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateAuditConfig(Packet packet) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET set AUDIT_ENABLE_=?,UPDATE_DATE_=?,UPDATE_USER_=?,AUDIT_INPUT_=?,AUDIT_OUTPUT_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBoolean(1, packet.isAuditEnable());
            preparedStatement.setTimestamp(2, new Timestamp(packet.getUpdateDate().getTime()));
            preparedStatement.setString(3, packet.getUpdateUser());
            preparedStatement.setString(4, packet.getAuditInput());
            preparedStatement.setString(5, packet.getAuditOutput());
            preparedStatement.setLong(6, packet.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketQuery newQuery() {
        return new PacketQueryImpl();
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
            PacketFileManager.ins.deleteByProjectId(l);
            PacketPackageManager.ins.deleteByProjectId(l);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public int getCount(long l) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select COUNT(*) RULE_COUNT_ from URULE_PACKET where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

