/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.apply;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyQuery;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyQueryImpl;
import com.bstek.urule.console.database.manager.packet.apply.detail.PacketApplyDetailManager;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.PacketApply;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class PacketApplyManagerImpl
implements PacketApplyManager {
    protected PacketApplyManagerImpl() {
    }

    @Override
    public void add(PacketApply packetApply) {
        Connection connection = JdbcUtils.getConnection();
        try {
            packetApply.setCreateDate(new Date());
            packetApply.setUpdateDate(new Date());
            String string = "insert into URULE_PACKET_APPLY(ID_,PACKET_ID_,DEPLOYED_PACKET_ID_,PROJECT_ID_,TYPE_,TITLE_,DESC_,APPROVER_,STATUS_,CREATE_USER_,CREATE_DATE_,UPDATE_DATE_) values(?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            packetApply.setId(IDGenerator.getInstance().nextId(IDType.PACKET_APPLY));
            preparedStatement.setLong(1, packetApply.getId());
            preparedStatement.setLong(2, packetApply.getPacketId());
            preparedStatement.setLong(3, packetApply.getDeployedPacketId());
            preparedStatement.setLong(4, packetApply.getProjectId());
            preparedStatement.setString(5, packetApply.getType().name());
            preparedStatement.setString(6, packetApply.getTitle());
            preparedStatement.setString(7, packetApply.getDesc());
            preparedStatement.setString(8, packetApply.getApprover());
            preparedStatement.setString(9, packetApply.getStatus().name());
            preparedStatement.setString(10, packetApply.getCreateUser());
            preparedStatement.setTimestamp(11, new Timestamp(packetApply.getCreateDate().getTime()));
            preparedStatement.setTimestamp(12, new Timestamp(packetApply.getUpdateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_APPLY where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByPacketId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            List<PacketApply> list = this.newQuery().packetId(l).list();
            for (PacketApply object2 : list) {
                PacketApplyDetailManager.ins.deleteByApplyId(object2.getId());
            }
            String string = "delete from URULE_PACKET_APPLY where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketApply load(long l) {
        List<PacketApply> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void update(long l, ApplyStatus applyStatus) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET_APPLY set STATUS_=?,UPDATE_DATE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, applyStatus.name());
            preparedStatement.setTimestamp(2, new Timestamp(new Date().getTime()));
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateDeployedPacketId(long l, long l2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET_APPLY set DEPLOYED_PACKET_ID_=?,UPDATE_DATE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.setTimestamp(2, new Timestamp(new Date().getTime()));
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketApplyQuery newQuery() {
        return new PacketApplyQueryImpl();
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PacketApplyDetailManager.ins.deleteByProjectId(l);
            String string = "delete from URULE_PACKET_APPLY where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

