/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.apply.detail;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.apply.detail.PacketApplyDetailManager;
import com.bstek.urule.console.database.manager.packet.apply.detail.PacketApplyDetailQuery;
import com.bstek.urule.console.database.manager.packet.apply.detail.PacketApplyDetailQueryImpl;
import com.bstek.urule.console.database.model.PacketApplyDetail;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class PacketApplyDetailManagerImpl
implements PacketApplyDetailManager {
    protected PacketApplyDetailManagerImpl() {
    }

    @Override
    public void add(PacketApplyDetail packetApplyDetail) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "insert into URULE_PACKET_APPLY_DETAIL(ID_,APPLY_ID_,PROJECT_ID_,DESC_,CREATE_USER_,CREATE_DATE_) values(?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            packetApplyDetail.setId(IDGenerator.getInstance().nextId(IDType.PACKET_APPLY_DETAIL));
            preparedStatement.setLong(1, packetApplyDetail.getId());
            preparedStatement.setLong(2, packetApplyDetail.getApplyId());
            preparedStatement.setLong(3, packetApplyDetail.getProjectId());
            preparedStatement.setString(4, packetApplyDetail.getDesc());
            preparedStatement.setString(5, packetApplyDetail.getCreateUser());
            preparedStatement.setTimestamp(6, new Timestamp(new Date().getTime()));
            packetApplyDetail.setCreateDate(new Date());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketApplyDetail load(long l) {
        List<PacketApplyDetail> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<PacketApplyDetail> loadByApplyId(long l) {
        return this.newQuery().applyId(l).list();
    }

    @Override
    public void deleteByApplyId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_APPLY_DETAIL where APPLY_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_APPLY_DETAIL where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketApplyDetailQuery newQuery() {
        return new PacketApplyDetailQueryImpl();
    }
}

