/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.deploy;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployManager;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployQuery;
import com.bstek.urule.console.database.manager.packet.deploy.PacketDeployQueryImpl;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileManager;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class PacketDeployManagerImpl
implements PacketDeployManager {
    protected PacketDeployManagerImpl() {
    }

    @Override
    public synchronized void add(PacketDeploy packetDeploy) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "insert into URULE_DEPLOYED_PACKET(ID_,PACKET_ID_,DESC_,APPLY_ID_,PROJECT_ID_,CONTENT_,VERSION_,CREATE_USER_,CREATE_DATE_,ENABLE_,STATUS_,DIGEST_) values(?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            if (packetDeploy.getId() == 0L) {
                packetDeploy.setId(IDGenerator.getInstance().nextId(IDType.DEPLOYED_PACKET));
            }
            if (StringUtils.isBlank(packetDeploy.getVersion())) {
                packetDeploy.setVersion(this.a(packetDeploy.getPacketId()));
            }
            preparedStatement.setLong(1, packetDeploy.getId());
            preparedStatement.setLong(2, packetDeploy.getPacketId());
            preparedStatement.setString(3, packetDeploy.getDesc());
            preparedStatement.setLong(4, packetDeploy.getApplyId());
            preparedStatement.setLong(5, packetDeploy.getProjectId());
            preparedStatement.setString(6, packetDeploy.getContent());
            preparedStatement.setString(7, packetDeploy.getVersion());
            preparedStatement.setString(8, packetDeploy.getCreateUser());
            preparedStatement.setTimestamp(9, new Timestamp(new Date().getTime()));
            preparedStatement.setBoolean(10, packetDeploy.isEnable());
            preparedStatement.setString(11, packetDeploy.getStatus().name());
            preparedStatement.setString(12, packetDeploy.getDigest());
            packetDeploy.setCreateDate(new Date());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    private String a(long l) {
        Page<PacketDeploy> page = this.newQuery().packetId(l).paging(1, 1);
        if (page.getData().size() > 0) {
            String string = ((PacketDeploy)page.getData().get(0)).getVersion();
            return FileUtils.getMaxVersion(string);
        }
        return "1.0.0";
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_DEPLOYED_PACKET where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
            PacketDeployFileManager.ins.deleteByDeployId(l);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByApplyId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            List<PacketDeploy> list = this.newQuery().applyId(l).listWithContent();
            for (PacketDeploy object2 : list) {
                PacketDeployFileManager.ins.deleteByDeployId(object2.getId());
            }
            String string = "delete from URULE_DEPLOYED_PACKET where APPLY_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByPacketId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            List<PacketDeploy> list = this.newQuery().packetId(l).listWithContent();
            for (PacketDeploy object2 : list) {
                PacketDeployFileManager.ins.deleteByDeployId(object2.getId());
            }
            String string = "delete from URULE_DEPLOYED_PACKET where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateEnable(long l, boolean bl) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_DEPLOYED_PACKET set ENABLE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void updateStatus(long l, ApplyStatus applyStatus) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_DEPLOYED_PACKET set STATUS_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, applyStatus.name());
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void disableAll(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_DEPLOYED_PACKET set ENABLE_=? where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setBoolean(1, false);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketDeploy load(long l) {
        List<PacketDeploy> list = this.newQuery().id(l).listWithContent();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PacketDeployFileManager.ins.deleteByProjectId(l);
            String string = "delete from URULE_DEPLOYED_PACKET where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketDeployQuery newQuery() {
        return new PacketDeployQueryImpl();
    }
}

