/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.deploy.file;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileManager;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileQuery;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileQueryImpl;
import com.bstek.urule.console.database.model.PacketDeployFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class PacketDeployFileManagerImpl
implements PacketDeployFileManager {
    protected PacketDeployFileManagerImpl() {
    }

    @Override
    public PacketDeployFile load(long l) {
        List<PacketDeployFile> list = this.newQuery().id(l).listWithContent();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<PacketDeployFile> loadFiles(long l) {
        return this.newQuery().packetDeployId(l).list();
    }

    @Override
    public List<PacketDeployFile> loadFilesWithContent(long l) {
        return this.newQuery().packetDeployId(l).listWithContent();
    }

    @Override
    public void deleteByDeployId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_DEPLOYED_PACKET_FILE where DEPLOYED_PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(PacketDeployFile packetDeployFile) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "insert into URULE_DEPLOYED_PACKET_FILE(ID_,DEPLOYED_PACKET_ID_,FILE_ID_,PROJECT_ID_,PATH_,VERSION_,CONTENT_,CREATE_USER_,CREATE_DATE_,DIGEST_) values(?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            packetDeployFile.setId(IDGenerator.getInstance().nextId(IDType.DEPLOYED_PACKET_FILE));
            preparedStatement.setLong(1, packetDeployFile.getId());
            preparedStatement.setLong(2, packetDeployFile.getPacketDeployId());
            preparedStatement.setLong(3, packetDeployFile.getFileId());
            preparedStatement.setLong(4, packetDeployFile.getProjectId());
            preparedStatement.setString(5, packetDeployFile.getPath());
            preparedStatement.setString(6, packetDeployFile.getVersion());
            preparedStatement.setString(7, packetDeployFile.getContent());
            preparedStatement.setString(8, packetDeployFile.getCreateUser());
            preparedStatement.setTimestamp(9, new Timestamp(new Date().getTime()));
            preparedStatement.setString(10, packetDeployFile.getDigest());
            packetDeployFile.setCreateDate(new Date());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketDeployFileQuery newQuery() {
        return new PacketDeployFileQueryImpl();
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_DEPLOYED_PACKET_FILE where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

