/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.file;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.file.PacketFileManager;
import com.bstek.urule.console.database.manager.packet.file.PacketFileQuery;
import com.bstek.urule.console.database.manager.packet.file.PacketFileQueryImpl;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class PacketFileManagerImpl
implements PacketFileManager {
    protected PacketFileManagerImpl() {
    }

    @Override
    public PacketFile load(long l) {
        List<PacketFile> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void add(PacketFile packetFile) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "insert into URULE_PACKET_FILE(ID_,PACKET_ID_,FILE_ID_,PROJECT_ID_,PATH_,VERSION_,DESC_,CREATE_USER_,UPDATE_USER_,CREATE_DATE_,UPDATE_DATE_) values(?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            packetFile.setId(IDGenerator.getInstance().nextId(IDType.PACKET_FILE));
            preparedStatement.setLong(1, packetFile.getId());
            preparedStatement.setLong(2, packetFile.getPacketId());
            preparedStatement.setLong(3, packetFile.getFileId());
            preparedStatement.setLong(4, packetFile.getProjectId());
            preparedStatement.setString(5, packetFile.getPath());
            preparedStatement.setString(6, packetFile.getVersion());
            preparedStatement.setString(7, packetFile.getDesc());
            preparedStatement.setString(8, packetFile.getCreateUser());
            preparedStatement.setString(9, packetFile.getCreateUser());
            preparedStatement.setTimestamp(10, new Timestamp(new Date().getTime()));
            preparedStatement.setTimestamp(11, new Timestamp(new Date().getTime()));
            packetFile.setCreateDate(new Date());
            packetFile.setUpdateDate(new Date());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_FILE where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByPacketId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_FILE where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(PacketFile packetFile) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET_FILE set FILE_ID_=?,PATH_=?,VERSION_=?,DESC_=?,UPDATE_USER_=?,UPDATE_DATE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, packetFile.getFileId());
            preparedStatement.setString(2, packetFile.getPath());
            preparedStatement.setString(3, packetFile.getVersion());
            preparedStatement.setString(4, packetFile.getDesc());
            preparedStatement.setString(5, packetFile.getUpdateUser());
            preparedStatement.setTimestamp(6, new Timestamp(new Date().getTime()));
            preparedStatement.setLong(7, packetFile.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_FILE where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketFileQuery newQuery() {
        return new PacketFileQueryImpl();
    }
}

