/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.file;

import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.packet.file.PacketFileQuery;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PacketFileQueryImpl
implements PacketFileQuery {
    private Long a;
    private Long b;
    private Long c;
    private List<Object> d = new ArrayList<Object>();

    protected PacketFileQueryImpl() {
    }

    @Override
    public List<PacketFile> list() {
        String string = "select ID_,PACKET_ID_,FILE_ID_,PROJECT_ID_,PATH_,VERSION_,DESC_,CREATE_USER_,UPDATE_USER_,CREATE_DATE_,UPDATE_DATE_ from URULE_PACKET_FILE";
        StringBuilder stringBuilder = this.a();
        if (stringBuilder.length() > 0) {
            string = string + " where" + stringBuilder.toString();
        }
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            JdbcUtils.fillPreparedStatementParameters(this.d, preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<PacketFile> list = this.a(resultSet);
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            List<PacketFile> list2 = list;
            return list2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    private List<PacketFile> a(ResultSet resultSet) throws Exception {
        ArrayList<PacketFile> arrayList = new ArrayList<PacketFile>();
        while (resultSet.next()) {
            PacketFile packetFile = new PacketFile();
            packetFile.setId(resultSet.getLong(1));
            packetFile.setPacketId(resultSet.getLong(2));
            packetFile.setFileId(resultSet.getLong(3));
            packetFile.setProjectId(resultSet.getLong(4));
            try {
                RuleFile ruleFile = FileManager.ins.get(packetFile.getFileId());
                packetFile.setPath(ruleFile.getPath());
            }
            catch (RuleException ruleException) {
                packetFile.setPath("\u6587\u4ef6\u5df2\u5220\u9664");
            }
            packetFile.setVersion(resultSet.getString(6));
            packetFile.setDesc(resultSet.getString(7));
            packetFile.setCreateUser(resultSet.getString(8));
            packetFile.setUpdateUser(resultSet.getString(9));
            packetFile.setCreateDate(new Date(resultSet.getTimestamp(10).getTime()));
            packetFile.setUpdateDate(new Date(resultSet.getTimestamp(11).getTime()));
            arrayList.add(packetFile);
        }
        return arrayList;
    }

    private StringBuilder a() {
        this.d.clear();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.a != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" ID_=?");
            this.d.add(this.a);
        }
        if (this.b != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" PACKET_ID_=?");
            this.d.add(this.b);
        }
        if (this.c != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and");
            }
            stringBuilder.append(" PROJECT_ID_=?");
            this.d.add(this.c);
        }
        return stringBuilder;
    }

    @Override
    public PacketFileQuery id(long l) {
        this.a = l;
        return this;
    }

    @Override
    public PacketFileQuery packetId(long l) {
        this.b = l;
        return this;
    }

    @Override
    public PacketFileQuery projectId(long l) {
        this.c = l;
        return this;
    }
}

