/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.packge;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.packge.PacketPackageManager;
import com.bstek.urule.console.database.model.PacketPackage;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;

public class PacketPackageManagerImpl
implements PacketPackageManager {
    protected PacketPackageManagerImpl() {
    }

    @Override
    public void add(PacketPackage packetPackage) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "insert into URULE_PACKET_PACKAGE(ID_,PACKET_ID_,DESC_,CREATE_USER_,UPDATE_USER_,CREATE_DATE_,UPDATE_DATE_,PROJECT_ID_,CONTENT_) values(?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            packetPackage.setId(IDGenerator.getInstance().nextId(IDType.PACKET_PACKAGE));
            preparedStatement.setLong(1, packetPackage.getId());
            preparedStatement.setLong(2, packetPackage.getPacketId());
            preparedStatement.setString(3, packetPackage.getDesc());
            preparedStatement.setString(4, packetPackage.getCreateUser());
            preparedStatement.setString(5, packetPackage.getCreateUser());
            preparedStatement.setTimestamp(6, new Timestamp(new Date().getTime()));
            preparedStatement.setTimestamp(7, new Timestamp(new Date().getTime()));
            preparedStatement.setLong(8, packetPackage.getProjectId());
            preparedStatement.setString(9, packetPackage.getContent());
            packetPackage.setCreateDate(new Date());
            packetPackage.setUpdateDate(new Date());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(PacketPackage packetPackage) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET_PACKAGE set DESC_=?,UPDATE_USER_=?,UPDATE_DATE_=?,CONTENT_=?  where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, packetPackage.getDesc());
            preparedStatement.setString(2, packetPackage.getUpdateUser());
            preparedStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
            preparedStatement.setString(4, packetPackage.getContent());
            preparedStatement.setLong(5, packetPackage.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByPacketId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_PACKAGE where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_PACKAGE where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public PacketPackage loadByPacketId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "select ID_,DESC_,CREATE_USER_,UPDATE_USER_,CREATE_DATE_,UPDATE_DATE_,PROJECT_ID_ from URULE_PACKET_PACKAGE where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            PacketPackage packetPackage = null;
            while (resultSet.next()) {
                packetPackage = new PacketPackage();
                packetPackage.setId(resultSet.getLong(1));
                packetPackage.setPacketId(l);
                packetPackage.setDesc(resultSet.getString(2));
                packetPackage.setCreateUser(resultSet.getString(3));
                packetPackage.setUpdateUser(resultSet.getString(4));
                packetPackage.setCreateDate(new Date(resultSet.getTimestamp(5).getTime()));
                packetPackage.setUpdateDate(new Date(resultSet.getTimestamp(6).getTime()));
                packetPackage.setProjectId(resultSet.getLong(7));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            PacketPackage packetPackage2 = packetPackage;
            return packetPackage2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public String loadContent(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "select CONTENT_ from URULE_PACKET_PACKAGE where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string2 = null;
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            String string3 = string2;
            return string3;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

