/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.packet.scenario;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.packet.deploy.file.PacketDeployFileManager;
import com.bstek.urule.console.database.manager.packet.scenario.ScenarioManager;
import com.bstek.urule.console.database.manager.packet.scenario.ScenarioQuery;
import com.bstek.urule.console.database.manager.packet.scenario.ScenarioQueryImpl;
import com.bstek.urule.console.database.model.Scenario;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class ScenarioManagerImpl
implements ScenarioManager {
    protected ScenarioManagerImpl() {
    }

    @Override
    public ScenarioQuery newQuery() {
        return new ScenarioQueryImpl();
    }

    @Override
    public Scenario load(long l) {
        List<Scenario> list = this.newQuery().id(l).list();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public byte[] loadExcelFile(long l) {
        String string = "select EXCEL_FILE_ from URULE_PACKET_SCENARIO where ID_=?";
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            byte[] byArray = null;
            if (resultSet.next()) {
                byArray = resultSet.getBytes(1);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void uploadExcel(long l, String string, byte[] byArray) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "update URULE_PACKET_SCENARIO set EXCEL_FILE_=?,UPDATE_USER_=?,UPDATE_DATE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setBytes(1, byArray);
            preparedStatement.setString(2, string);
            preparedStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public Scenario add(Scenario scenario) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "insert into URULE_PACKET_SCENARIO(ID_,PACKET_ID_,PROJECT_ID_,NAME_,DESC_,INPUT_DATA_,OUTPUT_DATA_,CREATE_USER_,UPDATE_USER_,CREATE_DATE_,UPDATE_DATE_) values(?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            scenario.setId(IDGenerator.getInstance().nextId(IDType.PACKET_SCENARIO));
            preparedStatement.setLong(1, scenario.getId());
            preparedStatement.setLong(2, scenario.getPacketId());
            preparedStatement.setLong(3, scenario.getProjectId());
            preparedStatement.setString(4, scenario.getName());
            preparedStatement.setString(5, scenario.getDesc());
            preparedStatement.setString(6, scenario.getInputData());
            preparedStatement.setString(7, scenario.getOutputData());
            preparedStatement.setString(8, scenario.getCreateUser());
            preparedStatement.setString(9, scenario.getCreateUser());
            preparedStatement.setTimestamp(10, new Timestamp(new Date().getTime()));
            preparedStatement.setTimestamp(11, new Timestamp(new Date().getTime()));
            scenario.setCreateDate(new Date());
            scenario.setUpdateDate(new Date());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(Scenario scenario) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "update URULE_PACKET_SCENARIO set NAME_=?,DESC_=?,EXCEL_FILE_NAME_=?,INPUT_DATA_=?,OUTPUT_DATA_=?,UPDATE_USER_=?,UPDATE_DATE_=? where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, scenario.getName());
            preparedStatement.setString(2, scenario.getDesc());
            preparedStatement.setString(3, scenario.getExcelFileName());
            preparedStatement.setString(4, scenario.getInputData());
            preparedStatement.setString(5, scenario.getOutputData());
            preparedStatement.setString(6, scenario.getUpdateUser());
            preparedStatement.setTimestamp(7, new Timestamp(scenario.getUpdateDate().getTime()));
            preparedStatement.setLong(8, scenario.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void delete(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_SCENARIO where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByProjectId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PacketDeployFileManager.ins.deleteByProjectId(l);
            String string = "delete from URULE_PACKET_SCENARIO where PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void deleteByPacketId(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "delete from URULE_PACKET_SCENARIO where PACKET_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

