/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.project;

import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.project.ProjectQuery;
import com.bstek.urule.console.database.manager.project.ProjectQueryImpl;
import com.bstek.urule.console.database.manager.project.user.UserQuery;
import com.bstek.urule.console.database.manager.project.user.UserQueryImpl;
import com.bstek.urule.console.database.model.ApplyType;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ProjectManagerImpl
implements ProjectManager {
    @Override
    public Project get(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_, NAME_, TYPE_, DESC_, GROUP_ID_, APPROVE_USER_ENABLE_, APPROVE_USER_DISABLE_, APPROVE_USER_DEPLOY_, CREATE_USER_, CREATE_DATE_, UPDATE_DATE_, UPDATE_USER_ from URULE_PROJECT where ID_=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            Project project = new Project();
            if (resultSet.next()) {
                project.setId(resultSet.getLong("ID_"));
                project.setName(resultSet.getString("NAME_"));
                project.setType(resultSet.getString("TYPE_"));
                project.setDesc(resultSet.getString("DESC_"));
                project.setGroupId(resultSet.getString("GROUP_ID_"));
                project.setEnableApproveUser(resultSet.getString("APPROVE_USER_ENABLE_"));
                project.setDisableApproveUser(resultSet.getString("APPROVE_USER_DISABLE_"));
                project.setDeployApproveUser(resultSet.getString("APPROVE_USER_DEPLOY_"));
                project.setCreateUser(resultSet.getString("CREATE_USER_"));
                project.setCreateDate(resultSet.getTimestamp("CREATE_DATE_"));
                project.setUpdateDate(resultSet.getTimestamp("UPDATE_DATE_"));
                project.setUpdateUser(resultSet.getString("UPDATE_USER_"));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            Project project2 = project;
            return project2;
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(Project project) {
        Connection connection = JdbcUtils.getConnection();
        try {
            project.setCreateDate(new Timestamp(System.currentTimeMillis()));
            project.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_PROJECT (ID_, NAME_, TYPE_, DESC_, GROUP_ID_, CREATE_DATE_, UPDATE_DATE_,CREATE_USER_,UPDATE_USER_,APPROVE_USER_ENABLE_,APPROVE_USER_DISABLE_,APPROVE_USER_DEPLOY_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if (project.getId() == null || project.getId() == 0L) {
                long l = IDGenerator.getInstance().nextId(IDType.PROJECT);
                project.setId(l);
            }
            preparedStatement.setLong(1, project.getId());
            preparedStatement.setString(2, project.getName());
            preparedStatement.setString(3, project.getType());
            preparedStatement.setString(4, project.getDesc());
            preparedStatement.setString(5, project.getGroupId());
            preparedStatement.setTimestamp(6, new Timestamp(project.getCreateDate().getTime()));
            preparedStatement.setTimestamp(7, new Timestamp(project.getUpdateDate().getTime()));
            preparedStatement.setString(8, project.getCreateUser());
            preparedStatement.setString(9, project.getCreateUser());
            preparedStatement.setString(10, project.getCreateUser());
            preparedStatement.setString(11, project.getCreateUser());
            preparedStatement.setString(12, project.getCreateUser());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(Project project) {
        Connection connection = JdbcUtils.getConnection();
        try {
            project.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_PROJECT set NAME_=?, TYPE_=?, DESC_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, project.getName());
            preparedStatement.setString(2, project.getType());
            preparedStatement.setString(3, project.getDesc());
            preparedStatement.setString(4, project.getUpdateUser());
            preparedStatement.setTimestamp(5, new Timestamp(project.getUpdateDate().getTime()));
            preparedStatement.setLong(6, project.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_PROJECT where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<Project> getProjectsByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string2 = "select ID_, NAME_, TYPE_, DESC_, GROUP_ID_, CREATE_DATE_, UPDATE_DATE_, UPDATE_USER_ from URULE_PROJECT WHERE GROUP_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new Project();
                ((Project)object).setId(resultSet.getLong("ID_"));
                ((Project)object).setName(resultSet.getString("NAME_"));
                ((Project)object).setType(resultSet.getString("TYPE_"));
                ((Project)object).setDesc(resultSet.getString("DESC_"));
                ((Project)object).setGroupId(resultSet.getString("GROUP_ID_"));
                ((Project)object).setCreateDate(resultSet.getTimestamp("CREATE_DATE_"));
                ((Project)object).setUpdateDate(resultSet.getTimestamp("UPDATE_DATE_"));
                ((Project)object).setUpdateUser(resultSet.getString("UPDATE_USER_"));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void addProjectUser(long l, String string, String string2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO URULE_PROJECT_USER (ID_, PROJECT_ID_, USER_ID_, USER_NAME_, CREATE_DATE_) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setLong(1, IDGenerator.getInstance().nextId(IDType.PROJECT_USER));
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string2);
            preparedStatement.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeProjectUser(long l, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_PROJECT_USER where PROJECT_ID_=? AND USER_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeProjectUsers(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_PROJECT_USER where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public String getApproveUser(long l, ApplyType applyType) {
        String string = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select APPROVE_USER_ENABLE_, APPROVE_USER_DISABLE_, APPROVE_USER_DEPLOY_, CREATE_USER_ from URULE_PROJECT where ID_=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                if (ApplyType.deploy == applyType) {
                    string = resultSet.getString(3);
                } else if (ApplyType.enable == applyType) {
                    string = resultSet.getString(1);
                } else if (ApplyType.disable == applyType) {
                    string = resultSet.getString(2);
                }
            }
            if (StringUtils.isEmpty(string)) {
                string = resultSet.getString(4);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
        return string;
    }

    @Override
    public void updateApproveUser(long l, ApplyType applyType, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "update URULE_PROJECT SET ";
            if (ApplyType.deploy == applyType) {
                string2 = string2 + "APPROVE_USER_DEPLOY_=?";
            } else if (ApplyType.enable == applyType) {
                string2 = string2 + "APPROVE_USER_ENABLE_=?";
            } else if (ApplyType.disable == applyType) {
                string2 = string2 + "APPROVE_USER_DISABLE_=?";
            }
            string2 = string2 + " where ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public ProjectQuery newQuery() {
        return new ProjectQueryImpl();
    }

    @Override
    public UserQuery createUserQuery() {
        return new UserQueryImpl();
    }
}

