/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.project.role;

import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.model.ProjectRole;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.model.UserRole;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ProjectRoleManagerImpl
implements ProjectRoleManager {
    @Override
    public List<Role> loadRoles(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string = "select ID_, NAME_, TYPE_, CREATE_DATE_, UPDATE_DATE_ from URULE_PROJECT_ROLE WHERE PROJECT_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new ProjectRole();
                ((Role)object).setId(resultSet.getLong(1));
                ((Role)object).setName(resultSet.getString(2));
                ((Role)object).setType(resultSet.getString(3));
                ((Role)object).setCreateDate(resultSet.getTimestamp(4));
                ((Role)object).setUpdateDate(resultSet.getTimestamp(5));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<Role> loadUserRoles(long l, String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string2 = "select URULE_PROJECT_ROLE.ID_, URULE_PROJECT_ROLE.NAME_, URULE_PROJECT_ROLE.TYPE_ from URULE_PROJECT_ROLE  LEFT JOIN URULE_PROJECT_USER_ROLE  ON URULE_PROJECT_ROLE.ID_=URULE_PROJECT_USER_ROLE.ROLE_ID_ WHERE URULE_PROJECT_ROLE.PROJECT_ID_=? AND URULE_PROJECT_USER_ROLE.USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new ProjectRole();
                ((Role)object).setId(resultSet.getLong(1));
                ((Role)object).setName(resultSet.getString(2));
                ((Role)object).setType(resultSet.getString(3));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public List<User> loadRoleUsers(long l, long l2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            Object object;
            String string = "select URULE_PROJECT_USER.USER_ID_, URULE_PROJECT_USER.USER_NAME_ from URULE_PROJECT_USER LEFT JOIN URULE_PROJECT_USER_ROLE on URULE_PROJECT_USER_ROLE.USER_ID_=URULE_PROJECT_USER.USER_ID_ WHERE URULE_PROJECT_USER.PROJECT_ID_=? and URULE_PROJECT_USER_ROLE.ROLE_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new User();
                ((User)object).setId(resultSet.getString(1));
                ((User)object).setName(resultSet.getString(2));
                arrayList.add(object);
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void add(ProjectRole projectRole) {
        Connection connection = JdbcUtils.getConnection();
        try {
            projectRole.setCreateDate(new Timestamp(System.currentTimeMillis()));
            projectRole.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            long l = IDGenerator.getInstance().nextId(IDType.PROJECT_ROLE);
            projectRole.setId(l);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_PROJECT_ROLE (ID_, NAME_, TYPE_, PROJECT_ID_, CREATE_USER_, CREATE_DATE_,UPDATE_DATE_) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setLong(1, projectRole.getId());
            preparedStatement.setString(2, projectRole.getName());
            preparedStatement.setString(3, projectRole.getType());
            preparedStatement.setLong(4, projectRole.getProjectId());
            preparedStatement.setString(5, projectRole.getCreateUser());
            preparedStatement.setTimestamp(6, new Timestamp(projectRole.getCreateDate().getTime()));
            preparedStatement.setTimestamp(7, new Timestamp(projectRole.getUpdateDate().getTime()));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void update(ProjectRole projectRole) {
        Connection connection = JdbcUtils.getConnection();
        try {
            projectRole.setUpdateDate(new Timestamp(System.currentTimeMillis()));
            PreparedStatement preparedStatement = connection.prepareStatement("update URULE_PROJECT_ROLE set NAME_=?, UPDATE_USER_=?, UPDATE_DATE_=? where ID_=?");
            preparedStatement.setString(1, projectRole.getName());
            preparedStatement.setString(2, projectRole.getUpdateUser());
            preparedStatement.setTimestamp(3, new Timestamp(projectRole.getUpdateDate().getTime()));
            preparedStatement.setLong(4, projectRole.getId());
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void remove(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_PROJECT_ROLE where ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public ProjectRole get(long l) {
        ProjectRole projectRole = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string = "select ID_, NAME_, TYPE_, PROJECT_ID_, CREATE_DATE_, UPDATE_DATE_ from URULE_PROJECT_ROLE WHERE ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                projectRole = new ProjectRole();
                projectRole.setId(resultSet.getLong(1));
                projectRole.setName(resultSet.getString(2));
                projectRole.setType(resultSet.getString(3));
                projectRole.setProjectId(resultSet.getLong(4));
                projectRole.setCreateDate(resultSet.getTimestamp(5));
                projectRole.setUpdateDate(resultSet.getTimestamp(6));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            ProjectRole projectRole2 = projectRole;
            return projectRole2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public boolean checkExist(long l, String string) {
        boolean bl = false;
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select ID_ FROM URULE_PROJECT_ROLE where PROJECT_ID_=? and NAME_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
        return bl;
    }

    @Override
    public void addUserRole(long l, String string, long l2) {
        Connection connection = JdbcUtils.getConnection();
        try {
            long l3 = IDGenerator.getInstance().nextId(IDType.PROJECT_ROLE);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into URULE_PROJECT_USER_ROLE (ID_, PROJECT_ID_, USER_ID_, ROLE_ID_) values (?, ?, ?, ?)");
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string);
            preparedStatement.setLong(4, l2);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public UserRole getUserRole(String string, long l) {
        UserRole userRole = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select ID_, ROLE_ID_, USER_ID_ from URULE_PROJECT_USER_ROLE WHERE ROLE_ID_=? and USER_ID_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                userRole = new UserRole();
                userRole.setId(resultSet.getLong(1));
                userRole.setRoleId(resultSet.getLong(2));
                userRole.setUserId(resultSet.getString(3));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            UserRole userRole2 = userRole;
            return userRole2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeUserRole(String string, long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_PROJECT_USER_ROLE WHERE USER_ID_=? and ROLE_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeRoleUsers(long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_PROJECT_USER_ROLE WHERE ROLE_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeUserRoles(String string) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from URULE_PROJECT_USER_ROLE WHERE USER_ID_=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public ProjectRole get(long l, String string) {
        ProjectRole projectRole = null;
        Connection connection = JdbcUtils.getConnection();
        try {
            String string2 = "select ID_, NAME_, TYPE_, CREATE_DATE_, UPDATE_DATE_ from URULE_PROJECT_ROLE WHERE PROJECT_ID_=? and NAME_=?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                projectRole = new ProjectRole();
                projectRole.setId(resultSet.getLong(1));
                projectRole.setName(resultSet.getString(2));
                projectRole.setType(resultSet.getString(3));
                projectRole.setCreateDate(resultSet.getTimestamp(4));
                projectRole.setUpdateDate(resultSet.getTimestamp(5));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
            ProjectRole projectRole2 = projectRole;
            return projectRole2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    @Override
    public void removeByProjectId(Long l) {
        Connection connection = JdbcUtils.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete FROM URULE_PROJECT_USER_ROLE where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
            preparedStatement = connection.prepareStatement("delete FROM URULE_PROJECT_ROLE where PROJECT_ID_=?");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }
}

