/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.database.manager.report;

import com.bstek.urule.console.database.manager.report.PacketDeployVO;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.PacketDeploy;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ReportGroupQuery {
    public static List<LinkedHashMap<String, Object>> countUserCreateProjects(String string) {
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select CREATE_USER_, COUNT(ID_) from URULE_PROJECT WHERE GROUP_ID_=?";
        string2 = string2 + " GROUP BY CREATE_USER_";
        try {
            Cloneable cloneable;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                cloneable = new LinkedHashMap();
                ((HashMap)cloneable).put("createUser", resultSet.getString(1));
                ((HashMap)cloneable).put("count", resultSet.getInt(2));
                arrayList.add(cloneable);
            }
            JdbcUtils.closeStatement(preparedStatement);
            cloneable = arrayList;
            return cloneable;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<PacketDeployVO> listPacketDeploys(String string) {
        Connection connection = JdbcUtils.getConnection();
        String string2 = "SELECT URULE_DEPLOYED_PACKET.ID_, URULE_DEPLOYED_PACKET.PACKET_ID_, URULE_PACKET.NAME_, URULE_DEPLOYED_PACKET.DESC_, URULE_DEPLOYED_PACKET.CREATE_USER_, URULE_DEPLOYED_PACKET.CREATE_DATE_, URULE_PROJECT.NAME_ from URULE_DEPLOYED_PACKET";
        string2 = string2 + " LEFT JOIN URULE_PACKET ON URULE_PACKET.ID_=URULE_DEPLOYED_PACKET.PACKET_ID_";
        string2 = string2 + " LEFT JOIN URULE_PROJECT ON URULE_PROJECT.ID_=URULE_DEPLOYED_PACKET.PROJECT_ID_";
        string2 = string2 + " WHERE URULE_PROJECT.GROUP_ID_=? order by URULE_DEPLOYED_PACKET.CREATE_DATE_ DESC";
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new PacketDeployVO();
                ((PacketDeploy)object).setId(resultSet.getLong(1));
                ((PacketDeploy)object).setPacketId(resultSet.getLong(2));
                ((PacketDeployVO)object).setPacketName(resultSet.getString(3));
                ((PacketDeploy)object).setDesc(resultSet.getString(4));
                ((PacketDeploy)object).setCreateUser(resultSet.getString(5));
                ((PacketDeploy)object).setCreateDate(resultSet.getTimestamp(6));
                ((PacketDeployVO)object).setProjectName(resultSet.getString(7));
                arrayList.add(object);
            }
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<RuleFile> listLastModifyFilesByGroupId(String string) {
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select URULE_FILE.ID_, URULE_FILE.NAME_, URULE_FILE.TYPE_, URULE_FILE.UPDATE_USER_, URULE_FILE.UPDATE_DATE_, URULE_FILE.PROJECT_ID_ from URULE_FILE";
        string2 = string2 + " left join URULE_PROJECT on URULE_PROJECT.ID_=URULE_FILE.PROJECT_ID_";
        string2 = string2 + " where URULE_PROJECT.GROUP_ID_=? order by URULE_FILE.UPDATE_DATE_ DESC";
        try {
            Object object;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new RuleFile();
                ((FileInfo)object).setId(resultSet.getLong(1));
                ((FileInfo)object).setName(resultSet.getString(2));
                ((RuleFile)object).setType(resultSet.getString(3));
                ((RuleFile)object).setUpdateUser(resultSet.getString(4));
                ((FileInfo)object).setCreateUser(resultSet.getString(4));
                ((RuleFile)object).setModifyDate(resultSet.getDate(5));
                ((RuleFile)object).setProjectId(resultSet.getLong(6));
                arrayList.add(object);
            }
            JdbcUtils.closeStatement(preparedStatement);
            object = arrayList;
            return object;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<LinkedHashMap<String, Object>> countProjectRuleFiles(String string) {
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select SUMMARY_.ID_, URULE_PROJECT.NAME_, SUMMARY_.RECORD_COUNT_ from ( select URULE_PROJECT.ID_, COUNT(URULE_FILE.ID_) as RECORD_COUNT_ from URULE_FILE LEFT JOIN URULE_PROJECT ON URULE_FILE.PROJECT_ID_=URULE_PROJECT.ID_";
        string2 = string2 + " where URULE_PROJECT.GROUP_ID_=? and URULE_FILE.DELETED_=?";
        string2 = string2 + " GROUP BY URULE_PROJECT.ID_ ) SUMMARY_";
        string2 = string2 + " left join URULE_PROJECT ON URULE_PROJECT.ID_=SUMMARY_.ID_";
        System.out.println(string2);
        try {
            Cloneable cloneable;
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setBoolean(2, false);
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                cloneable = new LinkedHashMap();
                ((HashMap)cloneable).put("projectId", resultSet.getLong(1));
                ((HashMap)cloneable).put("projectName", resultSet.getString(2));
                ((HashMap)cloneable).put("count", resultSet.getInt(3));
                arrayList.add(cloneable);
            }
            JdbcUtils.closeStatement(preparedStatement);
            cloneable = arrayList;
            return cloneable;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static int countFileByGroupId(String string) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select count(URULE_FILE.ID_) from URULE_FILE";
        string2 = string2 + " left join URULE_PROJECT on URULE_PROJECT.ID_=URULE_FILE.PROJECT_ID_";
        string2 = string2 + " where URULE_PROJECT.GROUP_ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static int countKnByGroupId(String string) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select count(URULE_PACKET.ID_) from URULE_PACKET";
        string2 = string2 + " left join URULE_PROJECT on URULE_PROJECT.ID_=URULE_PACKET.PROJECT_ID_";
        string2 = string2 + " where URULE_PROJECT.GROUP_ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static int countBatchByGroupId(String string) {
        int n = 0;
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select count(URULE_BATCH.ID_) from URULE_BATCH";
        string2 = string2 + " left join URULE_PROJECT on URULE_PROJECT.ID_=URULE_BATCH.PROJECT_ID_";
        string2 = string2 + " where URULE_PROJECT.GROUP_ID_=?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            JdbcUtils.closeStatement(preparedStatement);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    public static List<LinkedHashMap<String, Object>> getUserLoginCountByDay(String string, Date date, Date date2) {
        int n = ReportGroupQuery.a(date, date2);
        if (n > 31) {
            throw new RuleException("\u65e0\u6cd5\u7edf\u8ba1\u8d85\u8fc7\u4e00\u4e2a\u6708\u7684\u6570\u636e");
        }
        ArrayList<LinkedHashMap<String, Object>> arrayList = new ArrayList<LinkedHashMap<String, Object>>();
        Date date3 = new Date(date.getTime());
        Connection connection = JdbcUtils.getConnection();
        String string2 = "select count(URULE_LOG_USERLOGIN.ID_) from URULE_LOG_USERLOGIN";
        string2 = string2 + " left join URULE_GROUP_USER on URULE_GROUP_USER.USER_ID_=URULE_LOG_USERLOGIN.USER_ID_";
        string2 = string2 + " where URULE_GROUP_USER.GROUP_ID_=? and URULE_LOG_USERLOGIN.CREATE_DATE_>? and URULE_LOG_USERLOGIN.CREATE_DATE_<?";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            for (int i = 0; i < n; ++i) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date3);
                calendar.add(6, 1);
                Date date4 = calendar.getTime();
                int n2 = 0;
                preparedStatement.setString(1, string);
                preparedStatement.setTimestamp(2, new Timestamp(date3.getTime()));
                preparedStatement.setTimestamp(3, new Timestamp(date4.getTime()));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
                LinkedHashMap<String, Comparable<Integer>> linkedHashMap = new LinkedHashMap<String, Comparable<Integer>>();
                linkedHashMap.put("count", Integer.valueOf(n2));
                linkedHashMap.put("loginDate", date3);
                arrayList.add(linkedHashMap);
                date3 = calendar.getTime();
            }
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
        return arrayList;
    }

    private static int a(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int n = calendar.get(6);
        int n2 = calendar2.get(6);
        int n3 = calendar.get(1);
        int n4 = calendar2.get(1);
        if (n3 != n4) {
            int n5 = 0;
            for (int i = n3; i < n4; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    n5 += 366;
                    continue;
                }
                n5 += 365;
            }
            return n5 + (n2 - n);
        }
        return n2 - n;
    }
}

